% Kombinacija lokalnih i globalnih deskriptora pomocu stackinga.

%% Parameters

conf.workDir = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';
% Nruns-fold cross-validation
Nruns = 5;

%% Load descriptors (precomputed)

% local descriptors
load([conf.workDir '/ucm_size-256_patch-8_step-4_cw-1000']);
Nsamples = size(hist, 2);
Nclasses = length(unique(C));

meanrr1 = zeros(3, 1);
stdrr1 = zeros(3, 1);
meanrr2 = zeros(3, 1);
stdrr2 = zeros(3, 1);
meanrr3 = zeros(3, 1);
stdrr3 = zeros(3, 1);
meanrr4 = zeros(3, 1);
stdrr4 = zeros(3, 1);

s = 0;
% number of training images per class
for Ntrain_class = 80
    
    Cm1 = zeros(Nclasses, Nclasses, Nruns);
    Cm2 = zeros(Nclasses, Nclasses, Nruns);
    Cm3 = zeros(Nclasses, Nclasses, Nruns);
    Cm4 = zeros(Nclasses, Nclasses, Nruns);
    
    for r = 1:Nruns
        
        fprintf('Run: %d %d\n', Ntrain_class, r);
        
        %% Split training/test
        
        filename = sprintf('%s/train_test_%d_%d.mat', conf.workDir, Ntrain_class, r);
        
        if ~exist(filename, 'file')
            train_ind = [];
            
            for c = 1:Nclasses
                class_ind = find(C == c);
                ii = randperm(length(class_ind));
                train_ind = [train_ind; class_ind(ii(1:Ntrain_class))];
            end
            test_ind = setdiff(1:Nsamples, train_ind(:));
            save(filename, 'train_ind', 'test_ind');
        else
            load(filename);
        end
        train_ind = train_ind(:);
        
        ctest_hat4 = map_svm(hist, C, train_ind, test_ind, 1, 1e2);
        
        training_set = transpose(hist(:, train_ind));
        test_set = transpose(hist(:, test_ind));
        
        M = max(training_set);
        m = min(training_set);
        
        training_set = (training_set - repmat(m, size(training_set, 1), 1)) ./ repmat(M - m, size(training_set, 1), 1);
        test_set = (test_set - repmat(m, size(test_set, 1), 1)) ./ repmat(M - m, size(test_set, 1), 1);
        ind = find(M == m);
        training_set(:, ind) = 0;
        test_set(:, ind) = 0;

        sigma = std(training_set);
        
        scores = svm_level0_l1(training_set, test_set, sigma, 1e2, C(train_ind)', Nclasses, 1.0e0);
        ctest_hat1 = zeros(length(test_ind), 1);
        for k = 1:length(test_ind)
            [foo, ctest_hat1(k)] = max(scores(k, :));
        end
        
        model2 = libsvmtrain(C(train_ind)', double(training_set), '-c 1e1 -t 2 -g 1e-2');
        ctest_hat2 = svmpredict(C(test_ind)', double(test_set), model2);
        
        model3 = libsvmtrain(C(train_ind)', double(training_set), '-c 1e0 -t 0');
        ctest_hat3 = svmpredict(C(test_ind)', double(test_set), model3);

        Cm1(:, :, r) = conf_mat(ctest_hat1', C(test_ind), Nclasses);
        Cm2(:, :, r) = conf_mat(ctest_hat2', C(test_ind), Nclasses);
        Cm3(:, :, r) = conf_mat(ctest_hat3', C(test_ind), Nclasses);
        Cm4(:, :, r) = conf_mat(ctest_hat4, C(test_ind), Nclasses);
        
    end
        
    dd1 = zeros(Nclasses, Nruns);
    dd2 = zeros(Nclasses, Nruns);
    dd3 = zeros(Nclasses, Nruns);
    dd4 = zeros(Nclasses, Nruns);
    
    for r = 1:Nruns
        dd1(:, r) = diag(Cm1(:, :, r));
        dd2(:, r) = diag(Cm2(:, :, r));
        dd3(:, r) = diag(Cm3(:, :, r));
        dd4(:, r) = diag(Cm4(:, :, r));
    end
    
    s = s + 1;
    meanrr1(s) = mean(mean(dd1));
    stdrr1(s) = std(mean(dd1));
    meanrr2(s) = mean(mean(dd2));
    stdrr2(s) = std(mean(dd2));
    meanrr3(s) = mean(mean(dd3));
    stdrr3(s) = std(mean(dd3));
    meanrr4(s) = mean(mean(dd4));
    stdrr4(s) = std(mean(dd4));
    
    fprintf('%d: %.2f \\pm %.2f\n', Ntrain_class, meanrr1(s), stdrr1(s));
    fprintf('%d: %.2f \\pm %.2f\n', Ntrain_class, meanrr2(s), stdrr2(s));
    fprintf('%d: %.2f \\pm %.2f\n', Ntrain_class, meanrr3(s), stdrr3(s));
    fprintf('%d: %.2f \\pm %.2f\n', Ntrain_class, meanrr4(s), stdrr4(s));
    
end

