% Izdvajanje deskriptora za BoW klasifikator za aero slike. 
% Prilagodjen demo iz vlfeat (Andrea Vedaldi)

%% parametri

conf.imageDirRGB = 'C:\Users\User\Documents\MATLAB\download\UCMerced_LandUse\Images';
conf.workDir = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';
conf.ext = 'tif';
conf.size = 256;
conf.nWords = 1000;
conf.phowOpts = {'Sizes', 8, 'Step', 4, 'ContrastThreshold', 0, ...
    'Fast', true};
conf.quantizer = 'kdtree';
conf.filename = 'ucm';

opts.sizes = 8;
opts.step = 8;
opts.magnif = 3;
opts.contrastthreshold = 0;
opts.color = 0;
opts.fast = true;
opts = vl_argparse(opts, conf.phowOpts);

vocab_filename = sprintf('%s/%s_size-%d_patch%s_cw-%d_vocabulary', ...
    conf.workDir, conf.filename, conf.size, num2str(opts.sizes, '-%d'), conf.nWords);

%% racunanje PHOW deskriptora
filename = sprintf('%s/%s_size-%d_patch%s_step-%d_cw-%d', ...
    conf.workDir, conf.filename, conf.size, num2str(opts.sizes, '-%d'), conf.phowOpts{4}, conf.nWords);

load([vocab_filename '.mat'])

model.kdtree = vl_kdtreebuild(model.vocab);
model.quantizer = conf.quantizer;

if exist(filename, 'file')
    load(filename);
else
    categories = dir([conf.imageDirRGB '/*']);
    idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
    jj = 0;
    
    tic
    C = {};
    hist = {};
    images = {};
    for i = 1:length(idx)
        if categories(idx(i)).isdir
            dir_list = dir([conf.imageDirRGB '/' categories(idx(i)).name '/*.' conf.ext]);
            Nimages = length(dir_list);
            ims = cellfun(@(x) fullfile(categories(idx(i)).name, x), {dir_list.name}, 'UniformOutput', false) ;
            images = {images{:}, ims{:}} ;
            C{end+1} = i * ones(1,length(ims)) ;
        end
    end
    C = cat(2, C{:});
            
    parfor ii = 1:length(images)
        im = im2single(imread([conf.imageDirRGB '/' images{ii}]));
        if size(im, 1) ~= conf.size || size(im, 2) ~= conf.size
            im = imresize(im, [conf.size conf.size], 'bilinear');
        end
        im = rgb2gray(im);
        [frames descrs] = phow(im, conf.phowOpts{:});
        hist{ii} = getBoWDescriptor(model, double(descrs));
    end
    
    toc
    hist = cat(2, hist{:});
    save([filename '.mat'], 'hist', 'C');
end
