function hist = getBoWDescriptor(model, descrs)
% -------------------------------------------------------------------------
% by Andrea Vedaldi, taken from vlfeat demo
% -------------------------------------------------------------------------

% im = standarizeImage(im) ;
numWords = size(model.vocab, 2) ;

% quantize appearance
switch model.quantizer
  case 'omp'
    dots = model.vocab * descrs;
    phi1 = dots > 1;
    phi2 = -dots > 1;
    z = [phi1.*dots; -phi2.*dots];
    hist = single(sum(z, 2));
    hist = hist / size(descrs, 2);
%     [drop, idx] = max(abs(dots));
%     z = sparse(idx, 1:size(dots, 2), 1, size(dots, 1), size(dots, 2), size(dots, 2));
%     z = full(z .* dots);
%     hist = max(z, [], 2);
%     hist = single(sum(z, 2));
%     hist = hist/sum(hist);
    return
  case 'vq'
    [drop, binsa] = min(vl_alldist(model.vocab, single(descrs)), [], 1) ;
  case 'kdtree'
    binsa = double(vl_kdtreequery(model.kdtree, model.vocab, ...
                                  single(descrs), ...
                                  'MaxComparisons', 15)) ;
end
    
% quantize location
% binsx = vl_binsearch(linspace(1, sig.width, model.numSpatialX + 1), sig.frames(1,:)) ;
% binsy = vl_binsearch(linspace(1, sig.height, model.numSpatialY + 1), sig.frames(2,:)) ;

% combined quantization
% bins = sub2ind([model.numSpatialY, model.numSpatialX, numWords], ...
%                binsy, binsx, binsa) ;
% hist = zeros(model.numSpatialY * model.numSpatialX * numWords, 1) ;
bins = sub2ind([numWords, 1], binsa);
hist = zeros(numWords, 1);
hist = vl_binsum(hist, ones(size(bins)), bins) ;
hist = single(hist / sum(hist));
