conf.imageDirRGB = 'C:\Users\User\Documents\MATLAB\download\UCMerced_LandUse\Images';
conf.workDir = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';
conf.ext = 'tif';
conf.size = 256;
conf.nWords = 1000;
conf.nTrainingCodebook = 100;
conf.nPatches = 100;
conf.phowOpts = {'Sizes', 8, 'Step', 4, 'ContrastThreshold', 0, ...
    'Fast', true};
conf.filename = 'ucm';

opts.sizes = 8;
opts.step = 8;
opts.magnif = 3;
opts.contrastthreshold = 0;
opts.fast = true;
opts = vl_argparse(opts, conf.phowOpts);

filename = sprintf('%s/%s_size-%d_patch%s_cw-%d_vocabulary', ...
    conf.workDir, conf.filename, conf.size, num2str(opts.sizes, '-%d'), conf.nWords);

model.phowOpts = conf.phowOpts;
model.nWords = conf.nWords;

data = zeros(128, conf.nTrainingCodebook*conf.nPatches, 'single');
categories = dir([conf.imageDirRGB '/*']);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);

kk = 0;
for k = 1:conf.nTrainingCodebook
    c = randi(length(categories), 1);
    dir_list = dir([conf.imageDirRGB '/' categories(c).name '/*.' conf.ext]);
    Nimages = length(dir_list);
    ii = randi(Nimages, 1);
    im = im2single(imread([conf.imageDirRGB '/' categories(c).name '/' dir_list(ii).name]));
    im = rgb2gray(im);
    if size(im, 1) ~= conf.size || size(im, 2) ~= conf.size
        im = imresize(im, [conf.size, conf.size], 'bilinear');
    end
    [frames, descrs] = phow(im, conf.phowOpts{:});
    data(:, (k-1)*conf.nPatches+1:k*conf.nPatches) = vl_colsubset(descrs, conf.nPatches);
 end

model.vocab = vl_kmeans(data, conf.nWords, 'verbose', 'algorithm', 'elkan');
save([filename '.mat'], 'model');

