function ctest_hat = map_svm(hists, C, train_ind, test_ind, biasMultiplier, paramC)

psix = vl_homkermap(hists, 3, 0.3, 'kchi2');
% psix = vl_homkermap(hists, 3, 0.7, 'kl1');
% clear hists;

% training_set = psix(:, train_ind);
% 
% M = max(training_set, [], 2);
% m = min(training_set, [], 2);
% 
% psix = (psix - repmat(m, 1, size(psix, 2))) ./ repmat(M - m, 1, size(psix, 2));
% ind = M == m;
% psix(ind, :) = 0;

svm = train(C(train_ind)', ...
    sparse(double(psix(:, train_ind))),  ...
    sprintf(' -s 3 -B %f -c %f', biasMultiplier, paramC), ...
    'col');
w = svm.w';

b = biasMultiplier * w(end, :);
w = w(1:end-1, :);

% Estimate the class of the test images
similarity = w' * psix(:, test_ind) + b' * ones(1, length(test_ind));

[foo, ctest_hat] = max(similarity);

