function desc = gabor_descriptor_grayscale_p(im, GW, N, scales, orientations, p)
% moduli koeficijenata i razlika za sve kombinacije podopsega
% d1 - klasican Gaborov deskriptor za grayscale sliku
% d2 - center-surround (normalizovano srednjom vrijednoscu)
% d3 - oponentnost orijentacija (?) (normalizovano srednjom vrijednoscu)

im0 = rgb2gray(im);
A = fft2(im0);
C = zeros(N*scales, N*orientations);

for s = 1:scales,
    for n = 1:orientations,
        B = A .* GW(N*(s-1)+1:N*s, N*(n-1)+1:N*n);
        D = ifft2(B);
        C(N*(s-1)+1:N*s, N*(n-1)+1:N*n) = D;
        desc.d1(orientations*(s-1)+n, :) = [mean2(abs(D).^p) std2(abs(D).^p)].^(1/p);
    end
end

k = 0;
for s1 = 1:scales-1
    for s2 = s1+1:scales
        for n = 1:orientations
            D1 = C(N*(s1-1)+1:N*s1, N*(n-1)+1:N*n);
            D2 = C(N*(s2-1)+1:N*s2, N*(n-1)+1:N*n);
            D = D1/desc.d1(orientations*(s1-1)+n, 1) - D2/desc.d1(orientations*(s2-1)+n, 1);
            k = k + 1;
            desc.d2(k, :) = [mean2(abs(D).^p) std2(abs(D).^p)].^(1/p);
        end
    end
end

k = 0;
for n1 = 1:orientations-1
    for n2 = n1+1:orientations
        for s = 1:scales
            D1 = C(N*(s-1)+1:N*s, N*(n1-1)+1:N*n1);
            D2 = C(N*(s-1)+1:N*s, N*(n2-1)+1:N*n2);
            D = D1/desc.d1(orientations*(s-1)+n1, 1) - D2/desc.d1(orientations*(s-1)+n2, 1);
            k = k + 1;
            desc.d3(k, :) = [mean2(abs(D).^p) std2(abs(D).^p)].^(1/p);
            
        end
    end
end

desc.d1 = reshape(desc.d1, 1, numel(desc.d1));
desc.d2 = reshape(desc.d2, 1, numel(desc.d2));
desc.d3 = reshape(desc.d3, 1, numel(desc.d3));

