function K = l1_kernel(X1, X2, kernelpar)

[N1, d] = size(X1);
N2 = size(X2, 1);

K = zeros(N1, N2);
sigma = repmat(kernelpar, N1, 1);

for i = 1:N2
    Y2 = repmat(X2(i, :), N1, 1);
    K(:, i) = exp(-sum(abs(X1 - Y2) ./ (d*sigma), 2));
end  
