function ctest_hat = map_svm(training_set, test_set, Ctrain, biasMultiplier, paramC)

psix_training = vl_homkermap(training_set', 3, 0.7, 'kchi2');
psix_test = vl_homkermap(test_set', 3, 0.7, 'kchi2');

svm = train(Ctrain, ...
    sparse(double(psix_training)),  ...
    sprintf(' -s 3 -B %f -c %f', biasMultiplier, paramC), ...
    'col');
w = svm.w';

b = biasMultiplier * w(end, :);
w = w(1:end-1, :);

% Estimate the class of the test images
similarity = w' * psix_test + b' * ones(1, size(test_set, 1));

[foo, ctest_hat] = max(similarity);
