function ctest_hat = svm_classify(training_set, test_set, Ctrain, Nclasses, kernel, sigma, paramC)

Nfeatures = size(training_set, 2);

similarity = zeros(size(test_set, 1), Nclasses);

%% Train SVM (one-vs-all)

parfor c = 1:Nclasses
    netc = svm(Nfeatures, kernel, sigma, paramC);
    netc = svmtrain(netc, training_set, 2*(Ctrain == c)-1, [], 1);
    [Y, similarity(:, c)] = svmfwd(netc, test_set);
end

[foo, ctest_hat] = max(similarity ,[], 2);
