% NN classification of textures
%
%% Parameters

PREFIX = 'C:\Users\User\Documents\MATLAB\download\UCMerced_LandUse\Images';
DESCDIR = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';

categories = dir(PREFIX);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);
Nclasses = length(categories);

%% Load descriptors (precomputed)

load([DESCDIR '/ucm-grayscale-256-levels4-orientations6-abs-p0.25.mat']);

Nsamples = length(sig);
Nfeatures = length(sig(1).sig_grayscale.d1) + length(sig(1).sig_grayscale.d2) + length(sig(1).sig_grayscale.d3);

C = zeros(Nsamples, 1);
for i = 1:Nsamples
    C(i) = strmatch(sig(i).filename(1:end-6), {categories.name});
end

meanrr1 = zeros(9, 1);
stdrr1 = zeros(9, 1);
meanrr2 = zeros(9, 1);
stdrr2 = zeros(9, 1);
meanrr3 = zeros(9, 1);
stdrr3 = zeros(9, 1);
meanrr4 = zeros(9, 1);
stdrr4 = zeros(9, 1);

Nruns = 5;

s = 0;
for Ntrain_class = 80
    
    Cm1 = zeros(Nclasses, Nclasses, Nruns);
    Cm2 = zeros(Nclasses, Nclasses, Nruns);
    Cm3 = zeros(Nclasses, Nclasses, Nruns);
    Cm4 = zeros(Nclasses, Nclasses, Nruns);
    
    for r = 1:Nruns
        
        fprintf('Run: %d %d\n', Ntrain_class, r);
        
        %% Split training/test
         
        filename = sprintf('%s/train_test_%d_%d.mat', DESCDIR, Ntrain_class, r);
        
        if ~exist(filename, 'file')
            train_ind = [];
            
            for c = 1:Nclasses
                class_ind = find(C == c);
                ii = randperm(length(class_ind));
                train_ind = [train_ind; class_ind(ii(1:Ntrain_class))];
            end
            test_ind = setdiff(1:Nsamples, train_ind(:));
            save(filename, 'train_ind', 'test_ind');
        else
            load(filename);
        end
        train_ind = train_ind(:);
              
        training_set = zeros(length(train_ind), Nfeatures);
        test_set = zeros(length(test_ind), Nfeatures);
        for i = 1:length(train_ind)
            training_set(i, :) = [sig(train_ind(i)).sig_grayscale.d1, ...
                                  sig(train_ind(i)).sig_grayscale.d2, ...
                                  sig(train_ind(i)).sig_grayscale.d3];
        end
        for i = 1:length(test_ind)
            test_set(i, :) = [sig(test_ind(i)).sig_grayscale.d1, ...
                              sig(test_ind(i)).sig_grayscale.d2, ...
                              sig(test_ind(i)).sig_grayscale.d3];
        end
        
        M = max(training_set);
        m = min(training_set);
        
        training_set = (training_set - repmat(m, size(training_set, 1), 1)) ./ repmat(M - m, size(training_set, 1), 1);
        test_set = (test_set - repmat(m, size(test_set, 1), 1)) ./ repmat(M - m, size(test_set, 1), 1);
        
        sigma = std(training_set);

        %% Classify
        
        Ktrain = l1_kernel(training_set, training_set, sigma);
        Ktrain = [(1:length(train_ind))' Ktrain];
        Ktest = l1_kernel(test_set, training_set, sigma);
        Ktest = [(1:length(test_ind))' Ktest];
        
        model1 = libsvmtrain(C(train_ind), Ktrain, '-c 1e2 -t 4');
        ctest_hat1 = svmpredict(C(test_ind), Ktest, model1);
        
        model2 = libsvmtrain(C(train_ind), double(training_set), '-c 0.5e1 -t 2 -g 1e0');
        ctest_hat2 = svmpredict(C(test_ind), double(test_set), model2);
        
        model3 = libsvmtrain(C(train_ind), double(training_set), '-c 0.5e1 -t 0');
        ctest_hat3 = svmpredict(C(test_ind), double(test_set), model3);

        ctest_hat4 = map_svm(training_set, test_set, C(train_ind), 1.0, 1e1);
        
        %% Compute performances
        
        for j = 1:Nclasses
            for i = 1:Nclasses
                % row i, col j is the percentage of images from class i that
                % were missclassified as class j.
                Cm1(i, j, r) = 100*sum((C(test_ind)==i) .* (ctest_hat1==j))/sum(C(test_ind)==i);
                Cm2(i, j, r) = 100*sum((C(test_ind)==i) .* (ctest_hat2==j))/sum(C(test_ind)==i);
                Cm3(i, j, r) = 100*sum((C(test_ind)==i) .* (ctest_hat3==j))/sum(C(test_ind)==i);
                Cm4(i, j, r) = 100*sum((C(test_ind)==i) .* (ctest_hat4'==j))/sum(C(test_ind)==i);
            end
        end
        
    end
    
    dd1 = zeros(Nclasses, Nruns);
    dd2 = zeros(Nclasses, Nruns);
    dd3 = zeros(Nclasses, Nruns);
    dd4 = zeros(Nclasses, Nruns);
    for r = 1:Nruns
        dd1(:, r) = diag(Cm1(:, :, r));
        dd2(:, r) = diag(Cm2(:, :, r));
        dd3(:, r) = diag(Cm3(:, :, r));
        dd4(:, r) = diag(Cm4(:, :, r));
    end
    s = s + 1;
    meanrr1(s) = mean(mean(dd1));
    stdrr1(s) = std(mean(dd1));
    meanrr2(s) = mean(mean(dd2));
    stdrr2(s) = std(mean(dd2));
    meanrr3(s) = mean(mean(dd3));
    stdrr3(s) = std(mean(dd3));
    meanrr4(s) = mean(mean(dd4));
    stdrr4(s) = std(mean(dd4));

end

%% Print results

fprintf('RBF-L1: %f \\pm %f\n', meanrr1(1), stdrr1(1));
fprintf('RBF:    %f \\pm %f\n', meanrr2(1), stdrr1(1));
fprintf('Linear: %f \\pm %f\n', meanrr3(1), stdrr3(1));
fprintf('\\xi^2:  %f \\pm %f\n', meanrr4(1), stdrr4(1));

%% Plot graphs

% ratio = 10:10:90;
% figure
% plot(ratio, meanrr1, 'rx-', ...
%     ratio, meanrr2, 'bo-.', ...
%     ratio, meanrr3, 'm+--', ...
%     ratio, meanrr4, 'g*:', 'LineWidth', 2);
% xlabel('Broj trening slika po klasi', 'Interpreter', 'latex');
% ylabel('Ta\v{c}nost klasifikacije', 'Interpreter', 'latex');
% legend('RBF-L1', 'RBF', 'Linearni', '\chi^2', 'Location', 'SouthEast', 'Interpreter', 'latex')
