% Indeksiranje kolekcije tekstura
% Kategorije tekstura su u pojedinim direktorijumima

%% parameters

PREFIX = 'C:\Users\User\Documents\MATLAB\download\UCMerced_LandUse\Images';
DESCDIR = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';
ext = 'tif';

%% generate Gabor filter bank

N = 256;
scales = 4;
orientations = 6;
freq = [0.05 0.4];
flag = 0;

GW = gabor_generate(scales, orientations, N, freq, flag);

%% loop

m = 0;
n = 0;
sigma = 0;

tic
categories = dir(PREFIX);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
for i = 1:length(idx)
    if categories(idx(i)).isdir
        dir_list = dir([PREFIX '/' categories(idx(i)).name '/*.' ext]);
        for filename = {dir_list.name}
            filename = char(filename)
            X = imread([PREFIX '/' categories(idx(i)).name '/' filename]);
            X = im2double(X);
            if size(X, 1) ~= N || size(X, 2) ~= N
                X = imresize(X, [N N]);
            end
            n = n + 1;
            sig(n).filename = filename;
            sig(n).category = categories(idx(i)).name;
            sig(n).sig_grayscale = gabor_descriptor_grayscale_p(X, GW, N, scales, orientations, 0.25);
        end
    end
end
toc

save([DESCDIR '/ucm-grayscale-256-levels4-orientations6-abs-p0.25.mat'], 'sig');


