function ctest_hat = ridge_level1a(training_set, test_set, Ctraining, Nclasses, k)

scores = zeros(size(test_set, 1), Nclasses);
for c = 1:Nclasses
    w = ridge(double(Ctraining == c), training_set(:, [c c+Nclasses]), k, 0);
    scores(:, c) = [ones(size(test_set, 1), 1) test_set(:, [c c+Nclasses])] * w;
end

ctest_hat = zeros(size(test_set, 1), 1);
for k = 1:size(test_set, 1)
    [foo, ctest_hat(k)] = max(scores(k, :));
end