% Fusion of local and global descriptors

%% Parameters

PREFIX = 'C:\Users\User\Documents\MATLAB\download\UCMerced_LandUse\Images';
DESCDIR = 'C:\Users\User\Documents\MATLAB\aerial\stacking\publish\work';

% training/test set split ratio
Ntrain_class = 80;
% 
nfolds = 5;

% Nruns-fold cross-validation
Nruns = 5;

beta = 1;
%% Load descriptors (precomputed)

categories = dir(PREFIX);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);
Nclasses = length(categories);

% local descriptors
load([DESCDIR '/ucm_size-256_patch-8_step-4_cw-1000.mat'])
C = C';
data_bow = hist';
Nfeatures_local = size(data_bow, 2);

% global descriptors
load([DESCDIR '/ucm-grayscale-256-levels4-orientations6-abs-p0.25.mat'])

Nfeatures_global = length([sig(1).sig_grayscale.d1 sig(1).sig_grayscale.d2 sig(1).sig_grayscale.d3]);

data_egtd = zeros(length(sig), Nfeatures_global);

for i = 1:length(sig)
    data_egtd(i, :) = [sig(i).sig_grayscale.d1 sig(i).sig_grayscale.d2 sig(i).sig_grayscale.d3];
end
clear sig;

Cm1 = zeros(Nclasses, Nclasses, Nruns);
Cm2 = zeros(Nclasses, Nclasses, Nruns);
Cm3 = zeros(Nclasses, Nclasses, Nruns);
Cm4 = zeros(Nclasses, Nclasses, Nruns);
Cm5 = zeros(Nclasses, Nclasses, Nruns);
Cm6 = zeros(Nclasses, Nclasses, Nruns);
Cm7 = zeros(Nclasses, Nclasses, Nruns);
Cm8 = zeros(Nclasses, Nclasses, Nruns);
Cm9 = zeros(Nclasses, Nclasses, Nruns);
Cm10 = zeros(Nclasses, Nclasses, Nruns);
Cm11 = zeros(Nclasses, Nclasses, Nruns);
Cm12 = zeros(Nclasses, Nclasses, Nruns);
Cm13 = zeros(Nclasses, Nclasses, Nruns);

for r = 1:Nruns
    
    %% Split training/test
        
    filename = sprintf('work/train_test_%d_%d.mat', Ntrain_class, r);

    if ~exist(filename, 'file')
        train_ind = [];
        
        for c = 1:Nclasses
            class_ind = find(C == c);
            ii = randperm(length(class_ind));
            train_ind = [train_ind; class_ind(ii(1:Ntrain_class))];
        end
        test_ind = setdiff(1:Nsamples, train_ind(:));
        save(filename, 'train_ind', 'test_ind');
    else
        load(filename);
    end
    train_ind = train_ind';
    
    training_set1 = zeros(numel(train_ind), 2*Nclasses);
    Ctraining = zeros(numel(train_ind), 1);

    %% level 0 classifier
    fold_ind = randperm(size(train_ind, 1));
    Ntest_fold = floor(size(train_ind, 1)/nfolds);
    Ntest1 = Nclasses * Ntest_fold;

    for k = 1:nfolds
        fprintf('Fold %d\n', k);
        test_ind1 = train_ind(fold_ind((k-1)*Ntest_fold+1:k*Ntest_fold), :);
        test_ind1 = test_ind1(:);
        train_ind1 = setdiff(train_ind(:), test_ind1);
    
        training_set0 = data_bow(train_ind1, :);
        test_set0 = data_bow(test_ind1, :);
        
        sigma_bow = std(training_set0);

        % local
        fprintf('Local level 0 classifier...\n');
        similarity = svm_level0_l1(training_set0, test_set0, sigma_bow, 1e4, C(train_ind1), Nclasses, beta);

        % training set for level 1 classifier is constructed from the level 0 test
        % set (validation set would be more correct term)
        training_set1((k-1)*Ntest1+1:k*Ntest1, 1:Nclasses) = similarity;
        Ctraining((k-1)*Ntest1+1:k*Ntest1) = C(test_ind1);
    
        % global
        fprintf('Global level 0 classifier...\n');
        training_set0 = data_egtd(train_ind1, :);
        test_set0 = data_egtd(test_ind1, :);

        M = max(training_set0);
        m = min(training_set0);
        
        training_set0 = (training_set0 - repmat(m, size(training_set0, 1), 1)) ./ repmat(M - m, size(training_set0, 1), 1);
        test_set0 = (test_set0 - repmat(m, size(test_set0, 1), 1)) ./ repmat(M - m, size(test_set0, 1), 1);
        
        sigma_egtd = std(training_set0);
        
        similarity = svm_level0_l1(training_set0, test_set0, sigma_egtd, 1e1, C(train_ind1), Nclasses, beta);
        training_set1((k-1)*Ntest1+1:k*Ntest1, Nclasses+1:2*Nclasses) = similarity;
    end
        
    % final level 0 classifier
    fprintf('Local level 0 classifier - test set...\n');
    training_set = data_bow(train_ind(:), :);
    test_set = data_bow(test_ind, :);
    
    similarity1 = svm_level0_l1(training_set, test_set, sigma_bow, 1e4, C(train_ind(:)), Nclasses, beta);
    test_set1 = similarity1;
    
    fprintf('Global level 0 classifier - test set...\n');
    training_set = data_egtd(train_ind(:), :);
    test_set = data_egtd(test_ind, :);
    
    M = max(training_set);
    m = min(training_set);
    
    training_set = (training_set - repmat(m, size(training_set, 1), 1)) ./ repmat(M - m, size(training_set, 1), 1);
    test_set = (test_set - repmat(m, size(test_set, 1), 1)) ./ repmat(M - m, size(test_set, 1), 1);
    
    sigma_egtd = std(training_set);
    
    similarity2 = svm_level0_l1(training_set, test_set, sigma_egtd, 1e1, C(train_ind(:)), Nclasses, beta);
    test_set1 = [test_set1 similarity2];

    
%% level 1 classifier

    % local MAX
    ctest_hat1 = zeros(length(test_ind), 1);
    for i = 1:length(test_ind)
        [foo, ctest_hat1(i)] = max(similarity1(i, :));
    end
    
    Cm1(:, :, r) = conf_mat(ctest_hat1, C(test_ind), Nclasses);

    % global MAX
    ctest_hat2 = zeros(length(test_ind), 1);
    for i = 1:length(test_ind)
        [foo, ctest_hat2(i)] = max(similarity2(i, :));
    end
    
    Cm2(:, :, r) = conf_mat(ctest_hat2, C(test_ind), Nclasses);
   
    % concatenation
    training_set_concat = [data_egtd(train_ind(:), :) data_bow(train_ind(:), :)];
    test_set_concat = [data_egtd(test_ind, :) data_bow(test_ind, :)];
    
    M = max(training_set_concat);
    m = min(training_set_concat);
    
    training_set_concat = (training_set_concat - repmat(m, size(training_set_concat, 1), 1)) ./ repmat(M - m, size(training_set_concat, 1), 1);
    test_set_concat = (test_set_concat - repmat(m, size(test_set_concat, 1), 1)) ./ repmat(M - m, size(test_set_concat, 1), 1);
    idx = find(M == m);
    training_set_concat(:, idx) = 0;
    test_set_concat(:, idx) = 0;
    
    sigma = std(training_set_concat);

    similarity = svm_level0_l1(training_set_concat, test_set_concat, sigma, 1e2, C(train_ind(:)), Nclasses, beta);
    [foo, ctest_hat3] = max(similarity, [], 2);
    Cm3(:, :, r) = conf_mat(ctest_hat3, C(test_ind), Nclasses);
    
    % linear SVM
    ctest_hat4 = svm_level1(training_set1, test_set1, Ctraining, 1.0, 5e1);
    Cm4(:, :, r) = conf_mat(ctest_hat4, C(test_ind), Nclasses);
      
    % linear SVM C
    ctest_hat5 = svm_level1a(training_set1, test_set1, Ctraining, Nclasses, 1.0, 5e1);    
    Cm5(:, :, r) = conf_mat(ctest_hat5, C(test_ind), Nclasses);

    % linear regression
    ctest_hat6 = lsq_level1(double(training_set1), double(test_set1), Ctraining, Nclasses);
    Cm6(:, :, r) = conf_mat(ctest_hat6, C(test_ind), Nclasses);

    % linear regression C
    ctest_hat7 = lsq_level1a(double(training_set1), double(test_set1), Ctraining, Nclasses);
    Cm7(:, :, r) = conf_mat(ctest_hat7, C(test_ind), Nclasses);

    % ridge regression     
    ctest_hat8 = ridge_level1(training_set1, test_set1, Ctraining, Nclasses, 1e0);    
    Cm8(:, :, r) = conf_mat(ctest_hat8, C(test_ind), Nclasses);

    % ridge regression C     
    ctest_hat9 = ridge_level1a(training_set1, test_set1, Ctraining, Nclasses, 1e2);    
    Cm9(:, :, r) = conf_mat(ctest_hat9, C(test_ind), Nclasses);

    % RBF SVM
    ctest_hat10 = svm_level1_rbf(training_set1, test_set1, 1e-1, 1e2, Ctraining, Nclasses, beta);
    Cm10(:, :, r) = conf_mat(ctest_hat10, C(test_ind), Nclasses);
    
    % RBF SVM C
    ctest_hat11 = svm_level1a_rbf(training_set1, test_set1, 1e-2, 1e2, Ctraining, Nclasses, beta);
    Cm11(:, :, r) = conf_mat(ctest_hat11, C(test_ind), Nclasses);

    % RBF ridge regression
    ctest_hat12 = ridge_level1_rbf_kernel(training_set1, test_set1, Ctraining, Nclasses, 1e-3, 0.6e1);
    Cm12(:, :, r) = conf_mat(ctest_hat12, C(test_ind), Nclasses);

    % RBF ridge regression C
    ctest_hat13 = ridge_level1_rbf_kernel_c(training_set1, test_set1, Ctraining, Nclasses, 1e-5, 0.6e1);
    Cm13(:, :, r) = conf_mat(ctest_hat13, C(test_ind), Nclasses);
end

[mm, ss] = stats(Cm1);
fprintf('BoW: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm2);
fprintf('EGTD: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm3);
fprintf('Concatenation: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm4);
fprintf('lin. SVM: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm5);
fprintf('lin. SVM C: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm6);
fprintf('lin. regression: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm7);
fprintf('lin. regression C: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm8);
fprintf('ridge regression: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm9);
fprintf('ridge regression C: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm10);
fprintf('RBF SVM: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm11);
fprintf('RBF SVM C: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm12);
fprintf('RBF ridge regression: $ %.2f \\pm %.2f $\n', mm, ss);
[mm, ss] = stats(Cm13);
fprintf('RBF ridge regression C: $ %.2f \\pm %.2f $\n', mm, ss);

