function similarity = svm_level0_l1(training_set, test_set, sigma, paramC, Ctraining, Nclasses, beta)

Ktrain = l1_kernel(training_set, training_set, sigma);
Ktrain = [(1:size(training_set, 1))' Ktrain];
Ktest = l1_kernel(test_set, training_set, sigma);
Ktest = [(1:size(test_set, 1))' Ktest];

similarity = zeros(size(test_set, 1), Nclasses);

for c = 1:Nclasses
    model = libsvmtrain(double(Ctraining == c), Ktrain, ['-c ' num2str(paramC) ' -t 4']);
    [ctest_hat, foo, similarity(:, c)] = svmpredict(zeros(size(test_set, 1), 1), Ktest, model);
    similarity(:, c) = abs(similarity(:, c));
    similarity(ctest_hat == 0, c) = -similarity(ctest_hat == 0, c);
end
    
similarity = exp(beta*similarity) ./ repmat(sum(exp(beta*similarity), 2), 1, Nclasses);
