function ctest_hat = svm_level1(training_set, test_set, Ctraining, biasMultiplier, paramC)

svm = train(Ctraining, sparse(double(training_set)), ...
            sprintf(' -s 3 -B %f -c %f', biasMultiplier, paramC));
w = svm.w';

b = biasMultiplier * w(end, :);
w = w(1:end-1, :);

% Estimate the class of the test images
score = test_set * w + ones(size(test_set, 1), 1) * b;
[foo, ctest_hat] = max(score, [], 2);
