function ctest_hat = svm_level1a(training_set, test_set, Ctraining, Nclasses, biasMultiplier, paramC)

score = zeros(size(test_set, 1), Nclasses);
for c = 1:Nclasses
    svm = train(2*(Ctraining==c)-1, sparse(double(training_set(:, [c c+Nclasses]))), ...
            sprintf(' -s 3 -B %f -c %f', biasMultiplier, paramC));
    w = svm.w' * svm.Label(1);

    b = biasMultiplier * w(end, :);
    w = w(1:end-1, :);

    % Estimate the class of the test images
    score(:, c) = test_set(:, [c c+Nclasses]) * w + ones(size(test_set, 1), 1) * b;
end

[foo, ctest_hat] = max(score, [], 2);
