function ctest_hat = svm_level1a_rbf(training_set, test_set, sigma, paramC, Ctraining, Nclasses, beta)

similarity = zeros(size(test_set, 1), Nclasses);

gamma = 1/sigma/size(test_set, 2);

for c = 1:Nclasses
    model = libsvmtrain(double(Ctraining == c), training_set(:, [c c+Nclasses]), ...
        ['-c ' num2str(paramC) ' -g ' num2str(gamma) ' -t 2']);
    [ctest_hat, foo, similarity(:, c)] = ...
        svmpredict(zeros(size(test_set, 1), 1), test_set(:, [c c+Nclasses]), model);
    similarity(:, c) = abs(similarity(:, c));
    similarity(ctest_hat == 0, c) = -similarity(ctest_hat == 0, c);
end
    
[foo, ctest_hat] = max(similarity, [], 2);
