% Classification using SVM

%% Parameters
 
conf = get_conf();

% Nruns-fold cross-validation
Nruns = 5;

%% Load descriptors (precomputed)

categories = dir(conf.imageDir);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);
Nclasses = length(categories);

featuresFilename = sprintf('%s/%s_size-%d_step%s_pc-%d_cw-%d', conf.workDir, conf.featuresFilename, ...
    conf.patchSize, num2str(conf.patchStep, '-%d'), conf.nPC, conf.nWords);

load(featuresFilename);
Nsamples = size(hist, 2);

meanrr3 = zeros(3, 1);
stdrr3 = zeros(3, 1);

s = 0;
% number of training images per class
for ratio = 0.8
    
    Cm3 = zeros(Nclasses, Nclasses, Nruns);
    
    for r = 1:Nruns
                
        fprintf('Run: %d %d\n', ratio, r);
        
        %% Split training/test
        
        filename = sprintf('%s/train_test_%.1f_%d.mat', conf.workDir, ratio, r);
        if ~exist(filename, 'file')
            train_ind = [];
            for c = 1:Nclasses
                class_ind = transpose(find(C(1:2100) == c));
                ii = randperm(length(class_ind));
                Ntrain_class = floor(ratio * length(class_ind));
                Ntrain_class1 = min(Ntrain_class, length(class_ind));
                train_ind = [train_ind class_ind(ii(1:Ntrain_class1))];
            end
            test_ind = setdiff(1:2100, train_ind(:));
            
            save(filename, 'train_ind', 'test_ind');
        else
            load(filename);
        end

        train_ind = train_ind(:);
         
        training_set = sqrt(hist(:, train_ind));
        test_set = sqrt(hist(:, test_ind));
        
% L2
%         for q = 1:4
%             training_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :) = bsxfun(@rdivide, training_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :), 1e-3 + sqrt(sum(training_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :).^2)));
%             test_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :) = bsxfun(@rdivide, test_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :), 1e-3 + sqrt(sum(test_set(3*(q-1)*conf.nWords+1:3*q*conf.nWords, :).^2)));
%         end
%         for q = 1:4
%             training_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :) = bsxfun(@rdivide, training_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :), 1e-3 + sqrt(sum(training_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :).^2)));
%             test_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :) = bsxfun(@rdivide, test_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :), 1e-3 + sqrt(sum(test_set(2*(q-1)*conf.nWords+1:2*q*conf.nWords, :).^2)));
%         end

        training_set = bsxfun(@rdivide, training_set, 1e-3 + sqrt(sum(training_set.^2)));
        test_set = bsxfun(@rdivide, test_set, 1e-3 + sqrt(sum(test_set.^2)));
        
        scores = svm_level0_lin(training_set', test_set', 1e2, C(train_ind)', Nclasses);
        ctest_hat3 = zeros(length(test_ind), 1);
        for k = 1:length(test_ind)
            [foo, ctest_hat3(k)] = max(scores(k, :));
        end
        Cm3(:, :, r) = conf_mat(ctest_hat3', C(test_ind), Nclasses);
        
        
    end
        
    dd3 = zeros(Nclasses, Nruns);
    
    for r = 1:Nruns
        dd3(:, r) = diag(Cm3(:, :, r));
    end
    
    s = s + 1;
    meanrr3(s) = mean(mean(dd3));
    stdrr3(s) = std(mean(dd3));
    
    fprintf('linear 1-vs-all %f: %f+-%f\n', ratio, meanrr3(s), stdrr3(s));
    
end

