% quaternion PCA of patches

clear

conf = get_conf();

filename = sprintf('%s/%s_size-%d_pca', conf.workDir, conf.pcaFilename, conf.patchSize);

if conf.pixelPCA
    load('work/ucm_color-1_pixpca.mat');
    filename = [filename '_pixpca'];
end

data = zerosv(conf.patchSize*conf.patchSize, conf.nTrainingPCA*conf.nPatchesPCA*length(conf.size));

categories = dir([conf.imageDir '/*']);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);
%%

siz = conf.size;
ind = makeIndexMatrix(conf);
model.size = conf.size;
model.patchSize = conf.patchSize;

kk = 0;
for k = 1:conf.nTrainingPCA
    c = randi(length(categories), 1);
    dir_list = dir([conf.imageDir '/' categories(c).name '/*.' conf.ext]);
    Nimages = length(dir_list);
    ii = randi(Nimages, 1);
    im0 = im2single(imread([conf.imageDir '/' categories(c).name '/' dir_list(ii).name]));
    actual_size = size(im0);
    if conf.pixelPCA
        im0 = reshape(im0, actual_size(1)*actual_size(2), 3);
        im0 = pcaApply(im0', model.pixelU, model.pixelMu, 3);
        im0 = reshape(im0', actual_size(1), actual_size(2), 3);
        for m = 1:3
            im0(:, :, m) = mat2gray(im0(:, :, m));
        end
    end
    for s = 1:length(conf.size)
        im = imresize(im0, [siz(s), siz(s)], 'bilinear');
        im = quaternion(im(:, :, 1), im(:, :, 2), im(:, :, 3));
        kk = kk + 1;
        ind1 = ind{s}(:, randi(size(ind{s}, 2), 1, conf.nPatchesPCA));
        [frames, data(:, (kk-1)*conf.nPatchesPCA+1:kk*conf.nPatchesPCA)] = get_patches_grid_ind_sample(im, model, ind1);

    end
end

[U, S, V] = svd(data);
model.U = U;
model.S = S;

save(filename, 'model');

%% visualization

basis = zeros(conf.patchSize, conf.patchSize, 3, conf.patchSize*conf.patchSize);
for k = 1:conf.patchSize * conf.patchSize
%     basis(:, :, 1, k) = mat2gray(reshape(scalar(U(:, k)), conf.patchSize, conf.patchSize));
%     basis(:, :, 1, k) = mat2gray(reshape(x(U(:, k)), conf.patchSize, conf.patchSize));
%     basis(:, :, 2, k) = mat2gray(reshape(y(U(:, k)), conf.patchSize, conf.patchSize));
%     basis(:, :, 3, k) = mat2gray(reshape(z(U(:, k)), conf.patchSize, conf.patchSize));
    basis(:, :, 1, k) = reshape(x(U(:, k)), conf.patchSize, conf.patchSize);
    basis(:, :, 2, k) = reshape(y(U(:, k)), conf.patchSize, conf.patchSize);
    basis(:, :, 3, k) = reshape(z(U(:, k)), conf.patchSize, conf.patchSize);
    m = min(reshape(basis(:, :, :, k), [], 1));
    M = max(reshape(basis(:, :, :, k), [], 1));
    basis(:, :, :, k) = (basis(:, :, :, k) - m) / (M - m);
end

figure, montage(basis)
