conf.imageDirRGB = 'C:\Users\XNoize1987\Desktop\usgs\256x256';
conf.imageDirCIR = '';
conf.workDir = 'work';
conf.ext = 'tif';
conf.size = 256;
conf.nTrainingPCA = 1000;
conf.color = 1;
conf.filename = 'usgs';

pca_filename = sprintf('%s/%s_color-%d_pixpca.mat', conf.workDir, ...
        conf.filename, conf.color);
    
if conf.color == 1
    conf.nChannels = 3;
elseif conf.color == 2
    conf.nChannels = 4;
end

data = zeros(conf.nChannels, conf.nTrainingPCA*conf.size*conf.size, 'uint8');

categories = dir(conf.imageDirRGB);
idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
categories = categories(idx);

for k = 1:conf.nTrainingPCA
    c = randi(length(categories), 1);
    dir_list = dir([conf.imageDirRGB '/' categories(c).name '/*.' conf.ext]);
    Nimages = length(dir_list);
    ii = randi(Nimages, 1);
    im_rgb = im2single(imread([conf.imageDirRGB '/' categories(c).name '/' dir_list(ii).name]));
    if size(im_rgb, 1) ~= conf.size || size(im_rgb, 2) ~= conf.size
        im_rgb = imresize(im_rgb, [conf.size conf.size]);
    end
    im_rgb = reshape(im_rgb, conf.size*conf.size, 3);
    if conf.color == 2
        im_cir = im2single(imread([conf.imageDirCIR '/' categories(c).name '/' dir_list(ii).name]));
        if size(im_cir, 1) ~= conf.size || size(im_cir, 2) ~= conf.size
            im_cir = imresize(im_cir, [conf.size conf.size]);
        end
        im_cir = reshape(im_cir(:, :, 1), conf.size*conf.size, 1);
    else
        im_cir = [];
    end
    data(:, (k-1)*conf.size*conf.size+1:k*conf.size*conf.size) = [im_rgb'; im_cir'];
end

[model.pixelU, model.pixelMu] = pca(data);
    
save(pca_filename, 'model');


