% quaternion feature extraction 

%% parameters
conf = get_conf();

vocab_filename = sprintf('%s/%s_size-%d_pc-%d_cw-%d_vocabulary', ...
    conf.workDir, conf.codebookFilename, conf.patchSize, conf.nPC, conf.nWords);

filename = sprintf('%s/%s_size-%d_step%s_pc-%d_cw-%d', conf.workDir, conf.featuresFilename, ...
    conf.patchSize, num2str(conf.patchStep, '-%d'), conf.nPC, conf.nWords);

if conf.pixelPCA
    vocab_filename = [vocab_filename, '_pixpca'];
    filename = [filename, '_pixpca'];
end

load(vocab_filename)

if strcmp(conf.quantizer, 'kdtree')
    model.vocab = [scalar(model.vocab); x(model.vocab); y(model.vocab); z(model.vocab)];
    model.kdtree = vl_kdtreebuild(model.vocab);
end
model.quantizer = conf.quantizer;
model.nPC = conf.nPC;
model.patchSize = conf.patchSize;
model.dictLearning = conf.dictLearning;

%% image descriptor computation

ind = makeIndexMatrix(conf);

% if exist(filename, 'file')
%     load(filename);
% else
    categories = dir([conf.imageDir '/*']);
    idx = setdiff(1:length(categories), strmatch('.', {categories.name}));
    jj = 0;
    
    tic
    C = {};
    histq = {};
    images = {};
    for i = 1:length(idx)
        if categories(idx(i)).isdir
            dir_list = dir([conf.imageDir '/' categories(idx(i)).name '/*.' conf.ext]);
            Nimages = length(dir_list);
            ims = cellfun(@(x) fullfile(categories(idx(i)).name, x), {dir_list.name}, 'UniformOutput', false) ;
            images = {images{:}, ims{:}} ;
            C{end+1} = i * ones(1,length(ims)) ;
        end
    end
    C = cat(2, C{:});
    
    parfor ii = 1:length(images)
        im0 = im2double(imread([conf.imageDir '/' images{ii}]));
        actual_size = size(im0);
        if conf.pixelPCA
            im0 = reshape(im0, actual_size(1)*actual_size(2), 3);
            im0 = pcaApply(im0', model.pixelU, model.pixelMu, 3);
            im0 = reshape(im0', actual_size(1), actual_size(2), 3);
            for m = 1:3
                im0(:, :, m) = mat2gray(im0(:, :, m));
            end
        end
        frames = {};
        descrs = {};
        for k = 1:length(conf.size)
            im = imresize(im0, [conf.size(k) conf.size(k)], 'bilinear');
            im = quaternion(im(:, :, 1), im(:, :, 2), im(:, :, 3));
            [frames{k}, descrs{k}] = get_patches_grid_ind(im, model, ind{k});
        end
        frames = cat(2, frames{:});
%         descrs = cat(2, descrs{:});
        descrs = descrs{:};
%         descrs = (descrs - repmat(model.mu, 1, size(descrs, 2))) ./ repmat(model.sigma, 1, size(descrs, 2));
        histq{ii} = getBoWDescriptor(model, descrs, frames);
    end
    
    hist = cat(2, histq{:});

    toc
    
    save(filename, 'hist', 'C');
% end
