function hist = getBoWDescriptor(model, descrs, frames)
% -------------------------------------------------------------------------
% by Andrea Vedaldi, taken from vlfeat demo
% -------------------------------------------------------------------------

% im = standarizeImage(im) ;
nWords = size(model.vocab, 2);
nSamples = size(descrs, 2);

% descrs = bsxfun(@rdivide, bsxfun(@minus, descrs, model.mu), model.sigma);

switch model.quantizer
    case 'vq'
        model.vocab = [scalar(model.vocab); x(model.vocab); y(model.vocab); z(model.vocab)];
        descrs = [scalar(descrs); x(descrs); y(descrs); z(descrs)];
        [~, binsa] = min(vl_alldist(model.vocab, single(descrs)), [], 1) ;
    case 'kdtree'
        descrs = [scalar(descrs); x(descrs); y(descrs); z(descrs)];
        binsa = double(vl_kdtreequery(model.kdtree, model.vocab, descrs, ...
            'MaxComparisons',  15)) ;
    case 'qompk'
        if strcmp(model.dictLearning, 'qkmeans')
            model.vocab = model.vocab ./ repmat(sqrt(sum(abs(model.vocab).^2, 1)), size(model.vocab, 1), 1);
        end
        w = zerosq(nWords, nSamples);
        for k = 1:nSamples
            w(:, k) = qomp_iter(descrs(:, k), model.vocab, 5);
        end
        dots_scalar = single(scalar(w));
        dots_x = single(x(w));
        dots_y = single(y(w));
        dots_z = single(z(w));
        sorted_scalar = sort(abs(dots_scalar), 'descend');
        sorted_x = sort(abs(dots_x), 'descend');
        sorted_y = sort(abs(dots_y), 'descend');
        sorted_z = sort(abs(dots_z), 'descend');
        
        a_scalar = sorted_scalar(floor(0.4*nSamples));
        a_x = sorted_x(floor(0.4*nSamples));
        a_y = sorted_y(floor(0.4*nSamples));
        a_z = sorted_z(floor(0.4*nSamples));
        dots = [abs(dots_scalar); max(dots_scalar-a_scalar, 0); max(-dots_scalar-a_scalar, 0);
            abs(dots_x); max(dots_x-a_x, 0); max(-dots_x-a_x, 0);
            abs(dots_y); max(dots_y-a_y, 0); max(-dots_y-a_y, 0);
            abs(dots_z); max(dots_z-a_z, 0); max(-dots_z-a_z, 0)];
        hist = single(full(sum(dots, 2)));
        hist = hist / nSamples;
        return
    case 'qomp'
        if strcmp(model.dictLearning, 'qkmeans')
            model.vocab = model.vocab ./ repmat(sqrt(sum(abs(model.vocab).^2, 1)), size(model.vocab, 1), 1);
        end
        dots = model.vocab' * descrs;
        [mm, ind] = max(abs(dots));
        ind = sub2ind([nWords, nSamples], ind(:), (1:nSamples)');
        dots_scalar = sparse(nWords, nSamples);
        dots_x = sparse(nWords, nSamples);
        dots_y = sparse(nWords, nSamples);
        dots_z = sparse(nWords, nSamples);
        dots_scalar(ind) = scalar(dots(ind));
        dots_x(ind) = x(dots(ind));
        dots_y(ind) = y(dots(ind));
        dots_z(ind) = z(dots(ind));
        sorted_scalar = sort(abs(scalar(dots(ind))), 'descend');
        sorted_x = sort(abs(x(dots(ind))), 'descend');
        sorted_y = sort(abs(y(dots(ind))), 'descend');
        sorted_z = sort(abs(z(dots(ind))), 'descend');
        
        a_scalar = sorted_scalar(floor(0.4*nSamples));
        a_x = sorted_x(floor(0.4*nSamples));
        a_y = sorted_y(floor(0.4*nSamples));
        a_z = sorted_z(floor(0.4*nSamples));
        dots = [abs(dots_scalar); max(dots_scalar-a_scalar, 0); max(-dots_scalar-a_scalar, 0);
            abs(dots_x); max(dots_x-a_x, 0); max(-dots_x-a_x, 0);
            abs(dots_y); max(dots_y-a_y, 0); max(-dots_y-a_y, 0);
            abs(dots_z); max(dots_z-a_z, 0); max(-dots_z-a_z, 0)];
        hist = single(full(sum(dots, 2)));
        hist = hist / nSamples;
        return
    case 'qomp_abs'
        if strcmp(model.dictLearning, 'qkmeans')
            model.vocab = model.vocab ./ repmat(sqrt(sum(abs(model.vocab).^2, 1)), size(model.vocab, 1), 1);
        end
        dots = model.vocab' * descrs;
        [mm, ind] = max(abs(dots));
        ind = sub2ind([nWords, nSamples], ind(:), (1:nSamples)');
        dots_scalar = sparse(nWords, nSamples);
        dots_x = sparse(nWords, nSamples);
        dots_y = sparse(nWords, nSamples);
        dots_z = sparse(nWords, nSamples);
        dots_scalar(ind) = scalar(dots(ind));
        dots_x(ind) = x(dots(ind));
        dots_y(ind) = y(dots(ind));
        dots_z(ind) = z(dots(ind));
        dots = [abs(dots_scalar); 
                abs(dots_x); 
                abs(dots_y); 
                abs(dots_z)];
        hist = single(full(sum(dots, 2)));
        hist = hist / nSamples;
        return
    case 'qomp_thr'
        if strcmp(model.dictLearning, 'qkmeans')
            model.vocab = model.vocab ./ repmat(sqrt(sum(abs(model.vocab).^2, 1)), size(model.vocab, 1), 1);
        end
        dots = model.vocab' * descrs;
        [mm, ind] = max(abs(dots));
        ind = sub2ind([nWords, nSamples], ind(:), (1:nSamples)');
        dots_scalar = sparse(nWords, nSamples);
        dots_x = sparse(nWords, nSamples);
        dots_y = sparse(nWords, nSamples);
        dots_z = sparse(nWords, nSamples);
        dots_scalar(ind) = scalar(dots(ind));
        dots_x(ind) = x(dots(ind));
        dots_y(ind) = y(dots(ind));
        dots_z(ind) = z(dots(ind));
        sorted_scalar = sort(abs(scalar(dots(ind))), 'descend');
        sorted_x = sort(abs(x(dots(ind))), 'descend');
        sorted_y = sort(abs(y(dots(ind))), 'descend');
        sorted_z = sort(abs(z(dots(ind))), 'descend');
        
        a_scalar = sorted_scalar(floor(0.4*nSamples));
        a_x = sorted_x(floor(0.4*nSamples));
        a_y = sorted_y(floor(0.4*nSamples));
        a_z = sorted_z(floor(0.4*nSamples));
        dots = [max(dots_scalar-a_scalar, 0); max(-dots_scalar-a_scalar, 0);
                max(dots_x-a_x, 0); max(-dots_x-a_x, 0);
                max(dots_y-a_y, 0); max(-dots_y-a_y, 0);
                max(dots_z-a_z, 0); max(-dots_z-a_z, 0)];
        hist = single(full(sum(dots, 2)));
        hist = hist / nSamples;
        return
    case 'qomp_max'
        if strcmp(model.dictLearning, 'qkmeans')
            model.vocab = model.vocab ./ repmat(sqrt(sum(abs(model.vocab).^2, 1)), size(model.vocab, 1), 1);
        end
        dots = model.vocab' * descrs;
        [mm, ind] = max(abs(dots));
        ind = sub2ind([nWords, nSamples], ind(:), (1:nSamples)');
        dots_scalar = sparse(nWords, nSamples);
        dots_x = sparse(nWords, nSamples);
        dots_y = sparse(nWords, nSamples);
        dots_z = sparse(nWords, nSamples);
        dots_scalar(ind) = scalar(dots(ind));
        dots_x(ind) = x(dots(ind));
        dots_y(ind) = y(dots(ind));
        dots_z(ind) = z(dots(ind));
        sorted_scalar = sort(abs(scalar(dots(ind))), 'descend');
        sorted_x = sort(abs(x(dots(ind))), 'descend');
        sorted_y = sort(abs(y(dots(ind))), 'descend');
        sorted_z = sort(abs(z(dots(ind))), 'descend');
        
        a_scalar = sorted_scalar(floor(0.4*nSamples));
        a_x = sorted_x(floor(0.4*nSamples));
        a_y = sorted_y(floor(0.4*nSamples));
        a_z = sorted_z(floor(0.4*nSamples));
        dots = [abs(dots_scalar); max(dots_scalar-a_scalar, 0); max(-dots_scalar-a_scalar, 0);
            abs(dots_x); max(dots_x-a_x, 0); max(-dots_x-a_x, 0);
            abs(dots_y); max(dots_y-a_y, 0); max(-dots_y-a_y, 0);
            abs(dots_z); max(dots_z-a_z, 0); max(-dots_z-a_z, 0)];
        hist = single(full(max(dots, [], 2)));
        return
end
    
% quantize location
% binsx = vl_binsearch(linspace(1, sig.width, model.numSpatialX + 1), sig.frames(1,:)) ;
% binsy = vl_binsearch(linspace(1, sig.height, model.numSpatialY + 1), sig.frames(2,:)) ;

% combined quantization
% bins = sub2ind([model.numSpatialY, model.numSpatialX, numWords], ...
%                binsy, binsx, binsa) ;
% hist = zeros(model.numSpatialY * model.numSpatialX * numWords, 1) ;
bins = sub2ind([nWords, 1], binsa);
hist = zeros(nWords, 1);
hist = vl_binsum(hist, ones(size(bins)), bins) ;
hist = single(hist / sum(hist));
