function [frames, descrs] = get_patches_grid_ind(im, model, ind)
% get_patches_grid(im, model, ind) returns pixel values for uniformly distributed
% patches

data1 = im(ind);
frames = zeros(2, size(ind, 2));

% normalizacija
% mu = mean(data1);
% data1 = data1 - repmat(mu, model.patchSize*model.patchSize, 1);
% sigma = sqrt(sum(abs(data1).^2) + 1e0);
% sigma = repmat(sigma, model.patchSize*model.patchSize, 1);
% data1 = data1 ./ sigma;
 
if model.patchPCA == 1
    SS = diag(1./sqrt(diag(model.S) + 1e-1));
    descrs = model.U * SS * model.U' * data1;
elseif model.patchPCA == 2
    descrs = model.U(:, 1:model.nPC)' * data1;
else
    descrs = data1;
end

