function idx = makeIndexMatrix(conf)

idx = cell(length(conf.size), 1);

for k = 1:length(conf.size)
    mPatches = floor((conf.size(k) - conf.patchSize + conf.patchStep(k)) / conf.patchStep(k));
    nPatches = floor((conf.size(k) - conf.patchSize + conf.patchStep(k)) / conf.patchStep(k));

    idx{k} = zeros(conf.patchSize*conf.patchSize, mPatches*nPatches);

    rows = (0:conf.patchSize-1)';
    cols = (0:conf.patchSize-1)*conf.size(k)+1;

    ii = rows(:, ones(1, conf.patchSize)) + cols(ones(conf.patchSize, 1), :);
    ii = ii(:);

    for i = 1:mPatches
        for j = 1:nPatches
            idx{k}(:, (i-1)*nPatches+j) = ((i-1)*conf.patchStep(k)*conf.size(k)+(j-1)*conf.patchStep(k))+ii;
        end
    end
end

