function D = qksvd(Y, D0, K, numIter)
% quaternionic K-SVD
% aproksimativni algoritam iz "Efficient Implementation of the K-SVD Algorithm
% using Batch Orthogonal Matching Pursuit"
% direktna implementacija bez optimizacija ne radi zbog problema sa
% memorijom

numAtoms = size(D0, 2);
numSignals = size(Y, 2);

D = D0;

% X = zerosq(numAtoms, numSignals);
q = cell(numSignals, 1);
for j = 1:numIter
    tic
    fprintf('Iteration: %d/%d\n', j, numIter);
%     G = D'*D;
    parfor k = 1:numSignals
        % trebalo bi ovako ali ne moze u parfor iz nekog razloga
%         X(:, k) = qomp(Y(:, k), D, K);
        % ni ovo ne moze ...
%         q{k} = qomp(Y(:, k), D, K);
        w = qomp_iter(Y(:, k), D, K);
%         w = qomp(Y(:, k), D, K);
        q{k}.s = s(w);
        q{k}.x = x(w);
        q{k}.y = y(w);
        q{k}.z = z(w);
    end
    % ... jer se ovdje raspadne
%     X = 0 + cat(2, q{:});
    p = cat(2, q{:});
    ps = cat(2, p.s);
    px = cat(2, p.x);
    py = cat(2, p.y);
    pz = cat(2, p.z);
    X = quaternion(ps, px, py, pz);
    
    for k = 1:numAtoms
        idx = find(abs(X(k, :)) > 0);
        if ~isempty(idx)
%         E = Y(:, idx) - D * X(:, idx);       
%         [U, S, V] = svd(E, 0);
%         D(:, k) = U(:, 1);
%         X(k, idx) = S(1, 1) * V(:, 1); % treba conj za kvaternione
            D(:, k) = 0;
            x1 = X(k, idx)';
            d = Y(:, idx) * x1 - D * X(:, idx) * x1;
            d = d / sum(abs(x1).^2);
            x1 = Y(:, idx)' * d - (D * X(:, idx))' * d;
            D(:, k) = d;
            X(k, idx) = 0 + x1';
        end
    end
    toc
end
