function gamma = qomp_batch(x, D, G, K)
% Batch-QOMP quaternionic orthogonal matching pursuit

optsL.LT = true;
optsL_transp.LT = true;
optsL_transp.TRANSA = true;

num_atoms = size(D, 2);

active = zeros(1, K);
gamma = zerosq(num_atoms, 1);

L = zerosq(K);
L(1, 1) = quaternion(1, 0, 0, 0);
alpha0 = D' * x;
[~, idx] = max(abs(alpha0));
active(1) = idx;
gamma(idx) = alpha0(idx);
beta = G(:, active(1)) * gamma(active(1));
alpha = alpha0 - beta;

for k = 2:K    
    [alphamax, idx] = max(abs(alpha));
    if alphamax < 1e-5
        break;
    end
%     w = linsolve(L(1:k-1, 1:k-1), G(active(1:k-1), idx), optsL);
%     w = L(1:k-1, 1:k-1) \ G(active(1:k-1), idx);
    w = pinv(L(1:k-1, 1:k-1)) * G(active(1:k-1), idx);
    L(k, 1:k-1) = w';
    L(1:k-1, k) = zeros(k-1, 1);
    L(k, k) = sqrt(1 - w'*w);
    
    active(k) = idx;

%     c = linsolve(L(1:k, 1:k), alpha0(active(1:k)), optsL);
%     gamma(active(1:k)) = linsolve(L(1:k, 1:k), c, optsL_transp);
%     c = L(1:k, 1:k) \ alpha0(active(1:k));
    c = pinv(L(1:k, 1:k)) * alpha0(active(1:k));
%     gamma(active(1:k)) = L(1:k, 1:k)' \ c;
    gamma = pinv(L(1:k, 1:k)') * c;
    
    beta = G(:, active(1:k)) * gamma(active(1:k));
    alpha = alpha0 - beta;
end
    
