function alpha = qomp_iter(x, D, K)
% QOMP quaternionic orthogonal matching pursuit
% direktna varijanta bez ikakvih optimizacija

num_atoms = size(D, 2);

active = zeros(1, K);
alpha = zerosq(num_atoms, 1);
residue = x;

Ainv = zerosq(K);
Ainv(1, 1) = 1;
c = D' * residue;
[~, idx] = max(abs(c));
active(1) = idx;
alpha(idx) = c(idx);
residue = x - D(:, active(1))*alpha(active(1));

for k = 2:K    
    c = D' * residue;
    [cmax, idx] = max(abs(c));
    active(k) = idx;
    if cmax < 1e-5
        break;
    end
    
    % backslash ne radi za kvaternione
%     a = D(:, active(1:k)) \ x;
%     a = pinv(D(:, active(1:k))) * x;
    
    v = D(:, active(1:k-1))' * D(:, idx);
    b = Ainv(1:k-1, 1:k-1) * v;
    beta = 1 / (1 - v'*b);
    q = c(idx) * beta;
    alpha(active(1:k-1)) = alpha(active(1:k-1)) - b*q;
    alpha(active(k)) = q;
    Ainv(1:k-1, 1:k-1) = Ainv(1:k-1, 1:k-1) + beta*(b*b');
    Ainv(k, 1:k) = [-beta * b', beta];
    Ainv(1:k-1, k) = -beta * b;
   
    residue = x - D(:, active(1:k))*alpha(active(1:k));
end

