function showQDict(D, numPatches)
patchSize = sqrt(size(D, 1));
dictSize = min(numPatches, size(D, 2));

basis = zeros(patchSize, patchSize, 1, dictSize);
for k = 1:dictSize
    basis(:, :, 1, k) = reshape(s(D(:, k)), patchSize, patchSize);
    m = min(reshape(basis(:, :, :, k), [], 1));
    M = max(reshape(basis(:, :, :, k), [], 1));
    basis(:, :, :, k) = (basis(:, :, :, k) - m) / (M - m);
end

% figure, subplot(121), montage(basis)
figure, montage2(basis, struct('hasChn', 1, 'padAmt', 1, 'padEl', 1, 'showLines', 0))

basis = zeros(patchSize, patchSize, 3, dictSize);
for k = 1:dictSize
    basis(:, :, 1, k) = reshape(x(D(:, k)), patchSize, patchSize);
    basis(:, :, 2, k) = reshape(y(D(:, k)), patchSize, patchSize);
    basis(:, :, 3, k) = reshape(z(D(:, k)), patchSize, patchSize);
    m = min(reshape(basis(:, :, :, k), [], 1));
    M = max(reshape(basis(:, :, :, k), [], 1));
    basis(:, :, :, k) = (basis(:, :, :, k) - m) / (M - m);
end

% subplot(122), montage(basis)
figure, montage2(basis, struct('hasChn', 1, 'padAmt', 1, 'padEl', [1 1 1], 'showLines', 0))
