function similarity = svm_level0_lin(training_set, test_set, paramC, Ctraining, Nclasses, varargin)

if nargin == 5
    beta = 1.0;
else
    beta = varargin{1};
end

similarity = zeros(size(test_set, 1), Nclasses);

for c = 1:Nclasses
    model = svmtrain(double(Ctraining == c), double(training_set), ['-c ' num2str(paramC) ' -t 0']);
    [ctest_hat, foo, similarity(:, c)] = svmpredict(zeros(size(test_set, 1), 1), double(test_set), model);
    similarity(:, c) = abs(similarity(:, c));
    similarity(ctest_hat == 0, c) = -similarity(ctest_hat == 0, c);
end

similarity = exp(beta*similarity) ./ repmat(sum(exp(beta*similarity), 2), 1, Nclasses);