% Semestralni rad iz Digitalne Obrade Slike
% Izdvajanje regiona u kojima se nalazi tablica sa slike,normalizacija
% velicine tablice i uklanjanje distorzije.
% Student:
% Igor Maric
% Dragan Gracanin
% Supervizor:
% Vladimir Risojevic

% Help: Ulaz u funkciju je slika u boji, a izlaz siva slika izdvojene
% tablice!

function slika=isjecanje(a);
b=rgb2gray(a);
b=im2double(b);
% figure,imshow(b,[]),title('siva tablica') 

%sobel(izdvajanje ivica)
hsx=fspecial('sobel');
bsx=abs(imfilter(b,hsx,'replicate'));
% figure,imshow(bsx),title('Horizontalne ivice');
hsy=hsx';
bsy=abs(imfilter(b,hsy,'replicate'));
% figure,imshow(bsy),title('Vertikalne ivice');
bs=sqrt(bsx.^2+bsy.^2);
% figure,imshow(bs),title('Ivice')

%rotacija i transformacija
theta = 0:180;
[R,xp] = radon(bsx,theta);
% figure, imagesc(theta, xp, R); colormap(hot);
% xlabel('\theta (degrees)'); ylabel('\rho');
% title('R_{\theta} (\rho)');
% colorbar
[Y,I]=max(max(R));
teta=90-I;  % Ugao ya koji je tablica iskrivljena
T=[1 -tan(teta*pi/180) 0;0 1 0;0 0 1];
tform=maketform('affine',T);
b1=imtransform(b,tform);    %Ispravljanje tablice
% figure,imshow(b1,[]),title('Ispravljena tablica');

%Vertikalna projekcija
bsy=abs(imfilter(b1,hsy,'replicate'));
N=size(bsy,2);
M=size(bsy,1);
% figure, imshow(bsy),truesize;
% title('Vertikalne ivice');
py=sum(bsy, 2);
ii = find(py <= 0.3*max(py));
dii = diff(ii);
[m, kk] = max(dii);
ii1 = ii(kk);
ii2 = ii(kk+1);
b1 = b1(ii1:ii2, :);    %Tablica isjecena po horizontali
% figure, imshow(b1,[])

%Horizontalna projekcija
bsx = abs(imfilter(b1, hsx, 'replicate'));
% figure,imshow(bsx),title('Horizontalne ivice');
px = sum(bsx,1);
% figure,plot(px),title('Horizontalna projekcija');
N=length(px);
px1 = max(px) - px;
% figure, plot(px1), title('Horizontalna projekcija(inverzna)');
jj = find(px1 >= 0.8*max(px1));
djj=diff(jj);
kk=find(djj~=1);
jj1=jj(min(kk));
jj2=jj(max(kk)+1);
slika=b1(:, jj1:jj2);
slika=imresize(slika,[40,160],'bilinear');
figure, imshow(slika);
% title('Tablica');
