using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlikaLib;
using SeminarskiSlika;

namespace Kurtjak
{
    public partial class FilterForm : Form
    {
        private Slika slika;
        private Slika undoSlika;
        private SlikaForm sf;

        public FilterForm(SlikaForm sf)
        {
            InitializeComponent();
            this.slika = sf.original;
            this.undoSlika = sf.undoSlika;
            this.sf = sf;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                string boundaryType;
                if (radioButton6.Checked)
                    boundaryType = "zeros";
                else if (radioButton7.Checked)
                    boundaryType = "circular";
                else if (radioButton8.Checked)
                    boundaryType = "symmetric";
                else
                    boundaryType = "replicate";
                /////////////////////////////////
                sf.undoSlika = sf.original.getImgCopy();
                /////////////////////////////////
                Visible = false;
                sf.drawImage(0);
                if (radioButton1.Checked)
                    FunctionCollection.imFilter(slika, FunctionCollection.fSpecial("average", int.Parse(textBox1.Text)), int.Parse(textBox1.Text), int.Parse(textBox1.Text), boundaryType);
                else if (radioButton3.Checked)
                    FunctionCollection.imFilter(slika, FunctionCollection.fSpecial("gaussian", int.Parse(textBox1.Text), int.Parse(textBox1.Text), float.Parse(textBox2.Text), 0), int.Parse(textBox1.Text), int.Parse(textBox1.Text), boundaryType);
                else if (radioButton4.Checked)
                    FunctionCollection.medfilt2(slika, int.Parse(textBox1.Text), int.Parse(textBox1.Text), boundaryType);
                else if (radioButton5.Checked)
                    FunctionCollection.imFilter(slika, FunctionCollection.fSpecial("laplacian", 3, 3, 0, float.Parse(textBox1.Text)), 3, 3, boundaryType);
            }
            catch (Exception ex)
            {
                MessageBox.Show("Niste popunili sva potrebna polja!", "Greka");
                MessageBox.Show(ex.Message, "Greka");
            }
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if ((sender as RadioButton).Checked)
            {
                textBox2.Visible = false;
                label2.Visible = false;
            }
        }

        private void radioButton3_CheckedChanged(object sender, EventArgs e)
        {
            if ((sender as RadioButton).Checked)
            {
                textBox2.Visible = true;
                label2.Visible = true;
            }
        }

        private void radioButton5_CheckedChanged(object sender, EventArgs e)
        {
            if ((sender as RadioButton).Checked)
            {
                textBox2.Visible = false;
                label2.Visible = false;
            }
            label4.Visible = (sender as RadioButton).Checked;
            label1.Visible = !(sender as RadioButton).Checked;
        }

    }
}