﻿using System;
using System.Collections.Generic;
using System.Text;
using SlikaLib;
using System.Drawing;

namespace Ognjen
{
    public class ProsteOperacije
    {
        public static Slika flip(Slika original, bool horizontalno)
        {
            Slika rez = new Slika(original.Width, original.Height, original.ImageType);
            for (int x = 0; x < original.Width; x++)
            {
                for (int y = 0; y < original.Height; y++)
                {
                    if (original.ImageType == imgType.binary || original.ImageType == imgType.grayScale)
                    {
                        float pixVal = original.getPixelAt(x, y);
                        if (horizontalno) rez.setPixelAt(x, original.Height - y - 1, pixVal);
                        else rez.setPixelAt(original.Width - x - 1, y, pixVal);
                    }
                    else
                    {
                        Color boja = original.getPixelRGBAt(x, y);
                        if (horizontalno) rez.setPixelRGBAt(x, original.Height - y - 1, boja);
                        else rez.setPixelRGBAt(original.Width - x - 1, y, boja);
                    }
                }
            }
            return rez;
        }

        public static Slika negativ(Slika original)
        {
            Slika rez = new Slika(original.Width, original.Height, original.ImageType);
            for (int i = 0; i < original.Width; i++)
            {
                for (int j = 0; j < original.Height; j++)
                {
                    if (original.ImageType == imgType.binary || original.ImageType == imgType.grayScale)
                    {
                        float pixVal = original.getPixelAt(i, j);
                        rez.setPixelAt(i, j, (1 - pixVal));
                    }
                    else
                    {
                        Color boja = original.getPixelRGBAt(i, j);
                        rez.setPixelRGBAt(i, j, Color.FromArgb(255 - boja.R, 255 - boja.G, 255 - boja.B));
                    }
                }
            }
            return rez;
        }

        public static Slika rotate90(Slika original, bool uSmjeruKazaljke)
        {
            Slika rez = new Slika(original.Height, original.Width, original.ImageType);
            if (uSmjeruKazaljke)
            {
                for (int i = 0; i < original.Width; i++)
                {
                    for (int j = 0; j < original.Height; j++)
                    {
                        if(original.ImageType==imgType.binary || original.ImageType==imgType.grayScale) rez.setPixelAt(rez.Width - 1 - j, i, original.getPixelAt(i, j));
                        else rez.setPixelRGBAt(rez.Width - 1 - j, i, original.getPixelRGBAt(i, j));
                    }
                }
            }
            else
            {
                for (int i = 0; i < original.Width; i++)
                {
                    for (int j = 0; j < original.Height; j++)
                    {
                        if (original.ImageType == imgType.binary || original.ImageType == imgType.grayScale) rez.setPixelAt(j, rez.Height - 1 - i, original.getPixelAt(i, j));
                        else rez.setPixelRGBAt(j, rez.Height - 1 - i, original.getPixelRGBAt(i, j));
                    }
                }
            }
            return rez;
        }

        public static Slika crop(Slika original, int ax, int ay, int sirina, int visina)
        {
            Slika rez = new Slika(sirina, visina, original.ImageType);
            for (int i = ax, m = 0; i < ax + sirina; i++, m++)
                for (int j = ay, n = 0; j < ay + visina; j++, n++)
                    if (original.ImageType == imgType.rgb)
                        rez.setPixelRGBAt(m, n, original.getPixelRGBAt(i, j));
                    else
                        rez.setPixelAt(m, n, original.getPixelAt(i, j));
            return rez;
        }

        public static Slika delete(Slika original, int ax, int ay, int sirina, int visina)
        {
            Slika rez = new Slika(original.Width, original.Height, original.ImageType);
            for (int i = 0, m = 0; i < original.Width; i++, m++)
            {
                for (int j = 0, n = 0; j < original.Height; j++, n++)
                {
                    if (original.ImageType == imgType.binary || original.ImageType == imgType.grayScale)
                    {
                        if (i > ax && i < ax + sirina && j > ay && j < ay + visina) rez.setPixelAt(m, n, 1);
                        else rez.setPixelAt(m, n, original.getPixelAt(i, j));
                    }
                    else
                    {
                        if (i > ax && i < ax + sirina && j > ay && j < ay + visina) rez.setPixelRGBAt(m, n, Color.White);
                        else rez.setPixelRGBAt(m, n, original.getPixelRGBAt(i, j));
                    }
                }
            }
            return rez;
        }

        public static Slika histTransform(Slika original, int plow, int phigh, double gamma)
        {
            Slika rez = new Slika(original.Width, original.Height, original.ImageType);
            float plowf = ((float)plow) / 255;
            float phighf = ((float)phigh) / 255;
            for (int i = 0; i < original.Width; i++)
            {
                for (int j = 0; j < original.Height; j++)
                {
                    float val = original.getPixelAt(i, j);
                    if (val <= plowf) val = 0;
                    else if (val >= phighf) val = 1;
                    else val = (float)(Math.Pow(Convert.ToDouble((val - plow) / (phigh - plow)),gamma));
                    rez.setPixelAt(i, j, val);
                }
            }
            return rez;
        }
    }
}
