using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlikaLib;
using System.Drawing.Drawing2D;

namespace SeminarskiSlika
{
    public partial class Histogram : Form
    {
        public Histogram(Slika s)
        {
            InitializeComponent();
            this.s = s;
            tacke = getHistValues();
            //for (int i = 0; i < tacke.Length; i++) Console.WriteLine(tacke[i]);
            iscrtajHistogram();
        }

        private Point[] tacke;
        private Slika s;
        private int pola = 0;
        private int max = 0;

        private void iscrtajHistogram()
        {
            Graphics g = panel1.CreateGraphics();
            g.Clear(Color.FromKnownColor(KnownColor.ButtonFace));
            g.FillPolygon(Brushes.Black, tacke,FillMode.Alternate);
        }

        private Point[] getHistValues()
        {
            Point[] rez = new Point[257];
            int[] vals = new int[256];
            for (int i = 0; i < 255; i++) vals[i] = 0;
            for (int i = 0; i < s.Width; i++)
            {
                for (int j = 0; j < s.Height; j++)
                {
                    int val=(int)(s.getPixelAt(i, j)*255);
                    vals[val]++;
                    if (vals[val] > max) max = vals[val];
                }
            }
            pola = max / 2;
            for (int i = 0; i <= 255; i++)
            {
                double temp = (Convert.ToDouble(vals[i])) / max * 256;
                rez[i] = new Point(2 * i, 256 - (int)temp);
            }
            rez[256] = new Point(0, 256);
            return rez;
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            iscrtajHistogram();
        }
    }
}