using System;
using System.Collections.Generic;
using System.Text;
using SlikaLib;

namespace SkewDetection
{
    class Baird
    {
        private float objekat, pozadina, MARK;       
        private int nr, nc, velicina;
        private int ulr, ulc, lrr, lrc;

        private Slika original;
        private float[,] dataOriginal;

        private Slika bairdImage;
        public Slika BairdImage
        {
            get { return bairdImage; }
        }

        /* -------------------------------------------------------------------------------------------- */
        public Baird(Slika sOriginal)
        {
            objekat = 0;
            pozadina = 1;
            MARK = 2;
            velicina = 20;
            
            original = sOriginal;
            nc = original.Width;
            nr = original.Height;

            dataOriginal = new float[nc, nr];
            for (int i = 0; i < nc; i++)
                for (int j = 0; j < nr; j++)
                    dataOriginal[i, j] = original.getPixelAt(i,j);

            bairdImage = new Slika(nc, nr, original.ImageType);

            for (int i = 0; i < nc; i++)
                for (int j = 0; j < nr; j++)
                    bairdImage.setPixelAt(i, j, 0);

            markcc();

            for (int i = 0; i < nc; i++)
                for (int j = 0; j < nr; j++)
                    if (bairdImage.getPixelAt(i, j) > 0)
                        bairdImage.setPixelAt(i, j, 1);
        }

        /* -------------------------------------------------------------------------------------------- */
        private void markcc()
        {
	        for (int i=0; i < nc; i++)
	        {
	          for (int j=0; j < nr; j++)
                  if (dataOriginal[i, j] == objekat)
                        {
                            mark (i, j);
                            bbox (i, j);
                            bairdImage.setPixelAt((lrc + ulc) / 2, lrr, 1);
                            unmark(ulc, ulr, lrc, lrr);
                        }
	        }
        }

        /* -------------------------------------------------------------------------------------------- */
        private void mark(int col, int row)
        {
            dataOriginal[col, row] = MARK;
            if (row - 1 >= 0 && col - 1 >= 0 && dataOriginal[col - 1, row - 1] == objekat)
                mark(col - 1, row - 1);
            if (row - 1 >= 0 && dataOriginal[col, row - 1] == objekat)
                mark(col, row - 1);
            if (row - 1 >= 0 && col + 1 < nc && dataOriginal[col + 1, row - 1] == objekat)
                mark(col + 1, row - 1);
            if (col - 1 >= 0 && dataOriginal[col - 1, row] == objekat)
                mark(col - 1, row);
            if (col + 1 < nc && dataOriginal[col + 1, row] == objekat)
                mark(col + 1, row);
            if (row + 1 < nr && col - 1 >= 0 && dataOriginal[col - 1, row + 1] == objekat)
                mark(col - 1, row + 1);
            if (row + 1 < nr && dataOriginal[col, row + 1] == objekat)
                mark(col, row + 1);
            if (row + 1 < nr && col + 1 < nc && dataOriginal[col + 1, row + 1] == objekat)
                mark(col + 1, row + 1);
        }

        /* -------------------------------------------------------------------------------------------- */
        private void unmark (int nis, int js, int ie, int je)
        {
	        int i,j;

	        for (i=nis; i<=ie; i++)
	          for (j=js; j<=je; j++)
                  if (dataOriginal[i, j] == MARK)
                      dataOriginal[i, j] = pozadina;
        }

        /* -------------------------------------------------------------------------------------------- */
        private void bbox (int I, int J)
        {
	        int i,j,ip1,jp1,ip2,jp2;
	        int nis, ie, js, je;
        	 
	        ip1 = 10000;    jp1 = 10000;
	        ip2 = -1;       jp2 = -1;
         
	        if (I-velicina < 0) nis = 0;
	          else nis = I-velicina;
	        if (I+velicina >= nc) ie = nc-1;
	          else ie = I+velicina;
	        if (J-velicina < 0) js = 0;
	          else js = J-velicina;
	        if (J+velicina >= nr) je = nr-1;
	          else je = J+velicina;

            /* Find the min and max coordinates, both row and column */
	         for (i=nis; i<=ie; i++)
	           for(j=js; j<=je; j++)
                   if (dataOriginal[i, j] == MARK)
	             {
	               if (i < ip1) ip1 = i;
	               if (i > ip2) ip2 = i;
	               if (j < jp1) jp1 = j;
	               if (j > jp2) jp2 = j;
	             }

	         if (ip2 < 0) 
		         return;
         
	        ulc = ip1; ulr = jp1;
	        lrc = ip2; lrr = jp2;
         }
    }
}