using System;
using System.Collections.Generic;
using System.Text;
using SlikaLib;

namespace Kurtjak
{
    public class Aux
    {
        public static float L1(float r1, float g1, float b1, float r2, float g2, float b2)
        {
            return Math.Abs(r1 - r2) +
                    Math.Abs(g1 - g2) +
                    Math.Abs(b1 - b2);
        }

        public static float L2(float r1, float g1, float b1, float r2, float g2, float b2)
        {
            return (float)Math.Sqrt((r1 - r2) * (r1 - r2) +
                     (g1 - g2) * (g1 - g2) +
                     (b1 - b2) * (b1 - b2));
        }

        public static float gauss(float x, float sigma)
        {
            return (float)Math.Exp((double)((-x * x) / (2 * sigma * sigma)));
        }

        public static float[,] mat2Gray(float[,] value, int sirina, int visina, float minValue, float maxValue)
        {
            for (int i = 0; i < sirina; i++)
                for (int j = 0; j < visina; j++)
                    value[i, j] = (value[i, j] - minValue) / (maxValue - minValue);
            return value;
        }

        public static float[,] mat2Gray(float[,] value, int sirina, int visina)
        {
            float minValue = 10000;
            float maxValue = 0;
            for (int i = 0; i < sirina; i++)
                for (int j = 0; j < visina; j++)
                {
                    if (value[i, j] < minValue) minValue = value[i, j];
                    if (value[i, j] > maxValue) maxValue = value[i, j];
                }
            if ((maxValue > 1) || (minValue < 0))
                return mat2Gray(value, sirina, visina, minValue, maxValue);
            return value;
        }

        public static void printMatrix(float[,] f, int width, int height)
        {
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                    Console.Write(f[i, j] + "  ");
                Console.WriteLine();
            }
        }
    }

    public class FunctionCollection
    {
        public static float[,] getImgBoundary(Slika slika, int sirina, int visina, int red, int kolona, string ivicniTip)
        {
            float[,] retValue = new float[sirina, visina];
            int ii = red - sirina / 2;
            for (int i = 0; i < sirina; i++)
            {
                int jj = kolona - visina / 2;
                for (int j = 0; j < visina; j++)
                {
                    if ((ii < 0) || (ii >= slika.Width) || (jj < 0) || (jj >= slika.Height))
                    {
                        if (ivicniTip.Equals("zeros"))
                            retValue[i, j] = 0;
                        else if (ivicniTip.Equals("symmetric"))
                        {
                            if (ii < 0)
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[-ii - 1, -jj - 1];
                                else if (jj >= slika.Height)
                                    retValue[i, j] = slika.grayBuffer[-ii - 1, 2 * slika.Height - jj - 1];
                                else
                                    retValue[i, j] = slika.grayBuffer[-ii - 1, jj];
                            }
                            else if (ii >= slika.Width)
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[2 * slika.Width - ii - 1, -jj - 1];
                                else if (jj >= slika.Height)
                                    retValue[i, j] = slika.grayBuffer[2 * slika.Width - ii - 1, 2 * slika.Height - jj - 1];
                                else
                                    retValue[i, j] = slika.grayBuffer[2 * slika.Width - ii - 1, jj];
                            }
                            else
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[ii, -jj - 1];
                                else
                                    retValue[i, j] = slika.grayBuffer[ii, 2 * slika.Height - jj - 1];
                            }
                        }
                        else if (ivicniTip.Equals("replicate"))
                        {
                            if (ii < 0)
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[0, 0];
                                else if (jj >= slika.Height)
                                    retValue[i, j] = slika.grayBuffer[0, slika.Height - 1];
                                else
                                    retValue[i, j] = slika.grayBuffer[0, j];
                            }
                            else if (ii >= slika.Width)
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[slika.Width - 1, 0];
                                else if (jj >= slika.Height)
                                    retValue[i, j] = slika.grayBuffer[slika.Width - 1, slika.Height - 1];
                                else
                                    retValue[i, j] = slika.grayBuffer[slika.Width - 1, j];
                            }
                            else
                            {
                                if (jj < 0)
                                    retValue[i, j] = slika.grayBuffer[i, 0];
                                else
                                    retValue[i, j] = slika.grayBuffer[i, slika.Height - 1];
                            }
                        }
                        else if (ivicniTip.Equals("circular"))
                        {
                            retValue[i, j] = slika.grayBuffer[(ii + slika.Width) % slika.Width, (jj + slika.Height) % slika.Height];
                        }
                    }
                    else
                        retValue[i, j] = slika.grayBuffer[ii, jj];
                    jj++;
                }
                ii++;
            }
            return retValue;
        }

        public static Slika medfilt2(Slika slika, int sirina, int visina, string boundaryType)
        {
            slika.makeBuffer();
            Slika copy = slika.getImgCopy();
            for (int i = 0; i < copy.Width; i++)
                for (int j = 0; j < copy.Height; j++)
                {
                    float[,] f = getImgBoundary(copy, sirina, visina, i, j, boundaryType);
                    for (int ii = 0; ii < sirina * visina - 1; ii++)
                        for (int jj = ii; jj < sirina * visina; jj++)
                            if (f[ii / sirina, ii % sirina] > f[jj / sirina, jj % sirina])
                            {
                                float tmp = f[ii / sirina, ii % sirina];
                                f[ii / sirina, ii % sirina] = f[jj / sirina, jj % sirina];
                                f[jj / sirina, jj % sirina] = tmp;
                            }
                    slika.setPixelAt(i, j, f[sirina / 2, visina / 2]);
                }
            return slika;
        }

        public static Slika imNoise(Slika s, string noiseType, float freq)
        {
            if (noiseType.Equals("salt & pepper"))
            {
                int f = (int)(freq * 100);
                Random r = new Random();
                for (int i = 0; i < s.Width; i++)
                    for (int j = 0; j < s.Height; j++)
                    {
                        int rdm = r.Next(0, 100);
                        if (rdm < f / 2)
                            s.setPixelAt(i, j, 0);
                        else if (rdm >= (100 - f / 2))
                            s.setPixelAt(i, j, 1);
                    }
                return s;
            }
            else if (noiseType.Equals("gaussian"))
            {
                return s;
            }
            throw new Exception("Nije dobar parametar");
        }

        public static Slika imFilter(Slika slika, float[,] kernel, int sirina, int visina, string ivicniTip)
        {
            slika.makeBuffer();
            Slika copy = slika.getImgCopy();
            slika.minValue = 10000;
            slika.maxValue = 0;
            for (int i = 0; i < copy.Width; i++)
                for (int j = 0; j < copy.Height; j++)
                {
                    float[,] f = getImgBoundary(copy, sirina, visina, i, j, ivicniTip);

                    float sum = 0;
                    for (int ii = 0; ii < sirina; ii++)
                        for (int jj = 0; jj < visina; jj++)
                            sum += f[ii, jj] * kernel[ii, jj];
                    if (sum < slika.minValue) slika.minValue = sum;
                    if (sum > slika.maxValue) slika.maxValue = sum;
                    slika.grayBuffer[i, j] = sum;
                }
            slika.destroyGrayBuffer();
            return slika;
        }

        public static float[,] fSpecial(string type, int width, int height, float sigma, float alpha)
        {
            float[,] f = new float[width, height];
            if (type.Equals("average"))
            {
                for (int i = 0; i < width; i++)
                    for (int j = 0; j < height; j++)
                        f[i, j] = 1f / (width * height);
            }
            else if (type.Equals("laplacian"))
            {
                alpha = Math.Max(0, Math.Min(alpha, 1));
                f[0, 0] = f[0, 2] = f[2, 0] = f[2, 2] = alpha / (alpha + 1);
                f[0, 1] = f[1, 0] = f[1, 2] = f[2, 1] = (1 - alpha) / (alpha + 1);
                f[1, 1] = -4 / (alpha + 1);
            }
            else if (type.Equals("gaussian"))
            {
                float[,] g = new float[width, height];
                for (int i = 0; i < width; i++)
                    for (int j = 0; j < height; j++)
                    {
                        f[i, j] = (-width / 2) + i;
                        g[i, j] = (-height / 2) + j;
                    }
                if (sigma > 0)
                    for (int i = 0; i < width; i++)
                        for (int j = 0; j < height; j++)
                            f[i, j] = (float)Math.Exp(-(f[i, j] * f[i, j] + g[i, j] * g[i, j]) / (2 * sigma * sigma));

                float sum = 0;
                for (int i = 0; i < width; i++)
                    for (int j = 0; j < height; j++)
                        sum += f[i, j];
                if (sum > 0)
                    for (int i = 0; i < width; i++)
                        for (int j = 0; j < height; j++)
                            f[i, j] = f[i, j] / sum;
            }
            Aux.printMatrix(f, width, height);
            return f;
        }
        public static float[,] fSpecial(string type, int dimension)
        {
            if (type.Equals("average"))
            {
                return fSpecial(type, dimension, dimension, 0, 0);
            }
            else if (type.Equals("laplacian"))
            {
                return fSpecial(type, 3, 3, 0, 0.2f);// Radi samo za matrice 3 x 3;
            }
            else if (type.Equals("gaussian"))
            {
                return fSpecial(type, dimension, dimension, 0.5f, 0);
            }
            throw new Exception("fSpecial: Wrong function call!");
        }
        public static float[,] fSpecial(string type)
        {
            if (type.Equals("average"))
            {
                return fSpecial(type, 3, 3, 0, 0);
            }
            else if (type.Equals("laplacian"))
            {
                return fSpecial(type, 3, 3, 0, 0.2f);
            }
            else if (type.Equals("gaussian"))
            {
                return fSpecial(type, 3, 3, 0.5f, 0f);
            }
            throw new Exception("fSpecial: Wrong function call!");
        }
    }
}