﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Imaging;

namespace SeminarskiSlika
{
    public partial class GlavnaForma : Form
    {
        public GlavnaForma()
        {
            InitializeComponent();
            this.Size = Screen.PrimaryScreen.Bounds.Size;
        }

        private void OpenFile(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            openFileDialog.Filter = "Sve podržane slike (jpg, bmp, gif, tif)|*.jpg;*.bmp;*.gif;*.tif;*.tiff|JPG slike (*.jpg)|*.jpg|JPEG slike (*.jpeg)|*.jpeg|BMP slike (*.bmp)|*.bmp|GIF slike (*.gif)|*.gif|TIFF slike (*.tif)|*.tif|TIFF slike (*.tiff)|*.tiff";
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                string FileName = openFileDialog.FileName;
                SlikaForm sf = new SlikaForm(FileName);
                sf.MdiParent = this;
                sf.Show();
            }
        }

        private void ExitToolsStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }



        private void GlavnaForma_FormClosing(object sender, FormClosingEventArgs e)
        {
            Application.Exit();
        }

        private void otvoribinarnaSlikaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            openFileDialog.Filter = "Sve podržane slike (jpg, bmp, gif, tif)|*.jpg;*.bmp;*.gif;*.tif;*.tiff|JPG slike (*.jpg)|*.jpg|JPEG slike (*.jpeg)|*.jpeg|BMP slike (*.bmp)|*.bmp|GIF slike (*.gif)|*.gif|TIFF slike (*.tif)|*.tif|TIFF slike (*.tiff)|*.tiff";
            if (openFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                string FileName = openFileDialog.FileName;
                SlikaForm sf = new SlikaForm(FileName);
                sf.MdiParent = this;
                sf.Show();
            }
        }

        public void updateChildren(SlikaForm s)
        {
            //for (int i = 0; i < MdiChildren.GetLength(0); i++)
            //{
            //    SlikaForm sf = (SlikaForm)(MdiChildren[i]);
            //    if (sf.Equals(s)) continue;
            //    else sf.setUnsaved();
            //}
        }
    }
}
