﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SlikaLib;
using Ognjen;
using SkewDetection;
using System.Drawing.Imaging;
using Kurtjak;
using Zlatko;

namespace SeminarskiSlika
{
    public partial class SlikaForm : Form
    {
        public Slika undoSlika = null;
        public Slika original = null;

        private Point pointerStart = new Point(0, 0);
        private Point pointerEnd = new Point(0, 0);
        private Point pStart = new Point(0, 0);
        private Point pEnd = new Point(0, 0);
        private bool mouseDown = false;
        private Graphics picBoxG;

        public SlikaForm(string putanja)
        {
            InitializeComponent();
            original = Slika.readImage(putanja);
            this.Width = 550;
            this.Height = 550;
            this.Text = putanja;
            this.DoubleBuffered = true;
            drawImage(-2);
            this.SetStyle(ControlStyles.OptimizedDoubleBuffer, true);
            this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
            undoSlika = original;
            toolStripDropDownButton4.Enabled = (original.ImageType == imgType.grayScale);
        }

        public void drawImage(int flag)
        {
            if (flag < -1)
            {
                pictureBox1.Width = original.bmp.Width;
                pictureBox1.Height = original.bmp.Height;
            }
            if ((flag < 0) && (original != null))
            {
                picBoxG = pictureBox1.CreateGraphics();
            }
            Point pos = new Point(0, 0);
            if (pictureBox1.Width < ClientSize.Width)
                pos.X = (ClientSize.Width - pictureBox1.Width) / 2;
            if (pictureBox1.Height < ClientSize.Height)
                pos.Y = (ClientSize.Height - pictureBox1.Height) / 2;
            pictureBox1.Location = pos;
            pictureBox1.Image = new Bitmap(original.bmp);
            pictureBox1.Refresh();
        }

        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            mouseDown = true;
            pointerEnd = pictureBox1.PointToClient(Cursor.Position);
            pointerStart = pictureBox1.PointToClient(Cursor.Position);
        }

        private void myDrawRectangle()
        {
            pictureBox1.Image = new Bitmap(original.bmp);
            pictureBox1.Refresh();
            pStart.X = Math.Max(Math.Min(pointerStart.X, pointerEnd.X), 0);
            pStart.Y = Math.Max(Math.Min(pointerStart.Y, pointerEnd.Y), 0);
            pEnd.X = Math.Min(Math.Max(pointerStart.X, pointerEnd.X), pictureBox1.Width - 1);
            pEnd.Y = Math.Min(Math.Max(pointerStart.Y, pointerEnd.Y), pictureBox1.Height - 1);
            Pen p = new Pen(Color.OrangeRed);
            p.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;
            picBoxG.DrawRectangle(p, pStart.X, pStart.Y, pEnd.X - pStart.X, pEnd.Y - pStart.Y);
        }

        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            if (mouseDown)
                mouseDown = false;
            pointerEnd = pictureBox1.PointToClient(Cursor.Position);
            myDrawRectangle();
        }

        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            if (mouseDown)
            {
                pointerEnd = pictureBox1.PointToClient(Cursor.Position);
                myDrawRectangle();
            }
        }

        private void tsiCrop_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.crop(original, pStart.X, pStart.Y, pEnd.X - pStart.X, pEnd.Y - pStart.Y);
            drawImage(-2);
        }

        private void tsiDelete_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.delete(original, pStart.X, pStart.Y, pEnd.X - pStart.X, pEnd.Y - pStart.Y);
            drawImage(-1);
        }

        private void tsiNegative_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.negativ(original);
            drawImage(0);
        }

        private void tsiClockwise_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.rotate90(original, false);
            drawImage(-2);
        }

        private void tsiCounterclockwise_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.rotate90(original, true);
            drawImage(-2);
        }

        private void tsiVerticalFlip_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.flip(original, false);
            drawImage(0);
        }

        private void tsiHorizontalFlip_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = ProsteOperacije.flip(original, true);
            drawImage(0);
        }

        private void tsiSkew_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = HoughTransform.rotateSkewedImage(original);
            drawImage(0);
        }

        private void bairdImageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = HoughTransform.BairdImage(original);
            drawImage(0);
        }

        private void houghSpaceImageToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = HoughTransform.HoughSpaceImage(original);
            drawImage(0);
        }

        private void sačuvajToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog = new SaveFileDialog();
            saveFileDialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            saveFileDialog.Filter = "JPG slike (*.jpg)|*.jpg|JPEG slike (*.jpeg)|*.jpeg|BMP slike (*.bmp)|*.bmp|GIF slike (*.gif)|*.gif|TIFF slike (*.tif)|*.tiff|PNG slike (*.png)|*.png";
            if (saveFileDialog.ShowDialog(this) == DialogResult.OK)
            {
                string FileName = saveFileDialog.FileName;
                ImageFormat format = ImageFormat.Jpeg;
                if (FileName.EndsWith("gif")) format = ImageFormat.Gif;
                else if (FileName.EndsWith("bmp")) format = ImageFormat.Bmp;
                else if (FileName.EndsWith("tiff")) format = ImageFormat.Tiff;
                else if (FileName.EndsWith("png")) format = ImageFormat.Png;
                original.bmp.Save(FileName, format);
            }
        }

        private void zatvoriBezČuvanjaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show("Jeste li sigurni?", "Pitanje", MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes)
                this.Close();
        }

        private void prikažiHistogramToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (original.ImageType == imgType.grayScale)
            {
                Histogram h = new Histogram(original);
                h.MdiParent = this.MdiParent;
                h.Show();
            }
        }

        private void SlikaForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            GlavnaForma gf = (GlavnaForma)(this.MdiParent);
            gf.updateChildren(this);
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {
            original = undoSlika;
            drawImage(-2);
        }

        private void korekcijaHistogramaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (original.ImageType == imgType.grayScale)
            {
                HistOps ho = new HistOps();
                ho.ShowDialog(this);
                if (ho.Flag)
                {
                    int phigh = ho.PHigh;
                    int plow = ho.PLow;
                    double gamma = ho.Gamma;
                    undoSlika = original;
                    original = ProsteOperacije.histTransform(original, plow, phigh, gamma);
                    drawImage(0);
                }
            }
        }

        private void toGrayToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original.convertToGray();
            toolStripDropDownButton4.Enabled = true;
            drawImage(-1);
        }

        private void toBinaryToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original.convertToBinary(0.5f);
            drawImage(-1);
        }

        private void dodajŠumToolStripMenuItem_Click(object sender, EventArgs e)
        {
            noiseForm nf = new noiseForm(this);
            if (nf.ShowDialog() == DialogResult.OK) 
                drawImage(0);
        }

        private void filteriToolStripMenuItem_Click(object sender, EventArgs e)
        {
            FilterForm ff = new FilterForm(this);
            if (ff.ShowDialog() == DialogResult.OK)
                drawImage(0);
        }

        private void SlikaForm_Resize(object sender, EventArgs e)
        {
            drawImage(0);
        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {
            drawImage(0);
        }

        private void podesiStrukturniElementToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StrukturniElementForm sef = new StrukturniElementForm();
            if (sef.ShowDialog() != DialogResult.OK)
                Morfologija.strElement = null;
            else
                MessageBox.Show("Uspješno ste unijeli strukturni element!", "Poruka");
        }

        private void dilatacijaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = Morfologija.dilatacija(original);
            drawImage(-1);
        }

        private void erozijaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = Morfologija.erozija(original);
            drawImage(-1);
        }

        private void otvaranjeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = Morfologija.otvaranje(original);
            drawImage(-1);
        }

        private void zatvaranjeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            undoSlika = original.getImgCopy();
            original = Morfologija.zatvaranje(original);
            drawImage(-1);
        }

    }
}
