using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using SlikaLib;

namespace SkewDetection
{
    public class HoughTransform
    {
        /* -------------------------------------------------------------------------------------------- */
        public static Slika HoughSpaceImage(Slika original)
        {
            Hough hough = new Hough(original);
            Slika sOriginal = new Slika(hough.Omega, 2 * hough.RMax + 1, original.ImageType);
            for (int i = 0; i < hough.Omega; i++)
                for (int j = 0; j < 2 * hough.RMax + 1; j++)
                    sOriginal.setPixelAt(i, j, (hough.Data[i, j] / hough.TMVal)); //1:tmval=x:data            

            return sOriginal;
        }

        /* -------------------------------------------------------------------------------------------- */
        public static Slika BairdImage(Slika original)
        {
            Baird baird = new Baird(original);
            return baird.BairdImage;
        }

        /* -------------------------------------------------------------------------------------------- */
        public static Slika rotateSkewedImage(Slika sOriginal)
        {
            Slika original = sOriginal.getImgCopy();
            Baird baird = new Baird(original);
            Hough hough = new Hough(baird.BairdImage);
            float angle = -(hough.TMax-90);
            return rotateImage(sOriginal, angle);
        }

        /* -------------------------------------------------------------------------------------------- */
        public static Slika rotateImage(Slika original, float angle)
        {
            //form a bitmap from data from Slika original
            original.ImageType = imgType.binary;

            Bitmap b = Slika.Slika2Bitmap(original);            

            //create a new empty bitmap to hold rotated image
            Bitmap returnBitmap = new Bitmap(b.Width, b.Height);
            //make a graphics object from the empty bitmap
            Graphics g = Graphics.FromImage(returnBitmap);
            //clear graphic object with white color
            g.Clear(Color.White);
            //move rotation point to center of image
            g.TranslateTransform((float)original.Width / 2, (float)original.Height / 2);
            //rotate
            g.RotateTransform(angle);
            //move image back
            g.TranslateTransform(-(float)original.Width / 2, -(float)original.Height / 2);
            //draw passed in image onto graphics object
            g.DrawImage(b, new Point(0, 0));

            //translate rotated image back to type Slika
            original = Slika.Bitmap2Slika(returnBitmap);

            //convert to binary
            original.convertToBinary(0.5f);

            return original;
        }
    }
}
