﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace SlikaLib
{
    public enum imgType { binary, grayScale, rgb };

    public class Slika
    {
        public float minValue;
        public float maxValue;
        public float[,] grayBuffer = null;
                
        public Bitmap bmp;

        private imgType imageType;
        public imgType ImageType
        {
            set { }
            get { return imageType; }
        }

        public int Height
        {
            get { return bmp.Height; }
            set { }
        }

        public int Width
        {
            get { return bmp.Width; }
            set { }
        }

        public Slika getImgCopy()
        {
            return new Slika(this);
        }

        public void convertToBinary(float value)
        {
            if (this.ImageType == imgType.rgb)
            {
                float newPixelValue;
                for (int i = 0; i < Width; i++)
                    for (int j = 0; j < Height; j++)
                    {
                        if ((0.299f * ((float)bmp.GetPixel(i, j).R / 255)
                            + 0.587f * ((float)bmp.GetPixel(i, j).G / 255)
                            + 0.114f * ((float)bmp.GetPixel(i, j).B / 255)) > value)
                            newPixelValue = 1;
                        else
                            newPixelValue = 0;
                        bmp.SetPixel(i, j, Color.FromArgb((int)(newPixelValue * 255), (int)(newPixelValue * 255), (int)(newPixelValue * 255)));
                    }
            }
            else if (this.ImageType == imgType.grayScale)
            {
                int intvalue = (int) (value * 255);
                int newValue;
                for (int i = 0; i < Width; i++)
                    for (int j = 0; j < Height; j++)
                    {
                        if(bmp.GetPixel(i, j).B > intvalue)
                            newValue = 255;
                        else 
                            newValue = 0;
                        bmp.SetPixel(i, j, Color.FromArgb(newValue, newValue, newValue));
                    }
            }
        }

        public void convertToGray()
        {
            if (this.ImageType == imgType.rgb)
            {
                float newPixelValue;
                for (int i = 0; i < Width; i++)
                    for (int j = 0; j < Height; j++)
                    {
                        newPixelValue = 0.299f * ((float) bmp.GetPixel(i, j).R / 255)
                            + 0.587f * ((float) bmp.GetPixel(i, j).G / 255)
                            + 0.114f * ((float) bmp.GetPixel(i, j).B / 255);
                        bmp.SetPixel(i, j, Color.FromArgb((int)(newPixelValue * 255), (int)(newPixelValue * 255), (int)(newPixelValue * 255)));
                    }
                this.imageType = imgType.grayScale;
            }
        }

        public Color getPixelRGBAt(int x, int y)
        {
            return bmp.GetPixel(x, y);
        }

        public void setPixelRGBAt(int x, int y, Color value)
        {
            bmp.SetPixel(x, y, value);
        }

        public float getPixelAt(int x, int y)
        {
            return (float) bmp.GetPixel(x, y).R / 255;
        }

        public void setPixelAt(int x, int y, float value)
        {
            bmp.SetPixel(x, y, Color.FromArgb((int)(value * 255), (int)(value * 255), (int)(value * 255)));
        }

        public Slika(int width, int height, imgType iType)
        {
            this.bmp = new Bitmap(width, height, PixelFormat.Format32bppArgb);
            this.imageType = iType;
        }

        public Slika(string path)
        {
            Bitmap tmp = new Bitmap(path);
            this.bmp = new Bitmap(tmp);
            this.imageType = solveImgType(tmp);
        }

        public Slika(Bitmap bmp)
        {
            this.bmp = new Bitmap(bmp);
            this.imageType = solveImgType(bmp);
        }

        public Slika(Slika reff)
        {
            this.bmp = new Bitmap(reff.bmp);
            this.imageType = reff.ImageType;
            if (reff.grayBuffer != null)
                this.grayBuffer = (float[,])reff.grayBuffer.Clone();
            this.minValue = reff.minValue;
            this.maxValue = reff.maxValue;
        }

        public void makeBuffer()
        {
            grayBuffer = new float[Width, Height];
            for (int i = 0; i < Width; i++)
                for (int j = 0; j < Height; j++)
                    grayBuffer[i, j] = (float)bmp.GetPixel(i, j).B / 255;
        }

        public void destroyGrayBuffer()
        {
            if ((maxValue > 1) || (minValue < 0))
                for (int i = 0; i < Width; i++)
                    for (int j = 0; j < Height; j++)
                        bmp.SetPixel(i, j, Color.FromArgb(
                            (int)(((grayBuffer[i, j] - minValue) / (maxValue - minValue)) * 255),
                            (int)(((grayBuffer[i, j] - minValue) / (maxValue - minValue)) * 255),
                            (int)(((grayBuffer[i, j] - minValue) / (maxValue - minValue)) * 255)));
            else
                for (int i = 0; i < Width; i++)
                    for (int j = 0; j < Height; j++)
                        bmp.SetPixel(i, j, Color.FromArgb(
                           (int)(grayBuffer[i, j] * 255),
                           (int)(grayBuffer[i, j] * 255),
                           (int)(grayBuffer[i, j] * 255)));
            this.grayBuffer = null;
            GC.Collect();
        }

        public static imgType solveImgType(Bitmap slika)
        {
            if ((slika.Flags & 64) == 64)
                return imgType.grayScale;
            return imgType.rgb;
        }

        public static Slika readImage(string filePath)
        {
            return new Slika(filePath);
        }

        public static Slika Bitmap2Slika(Bitmap returnBitmap)
        {
            return new Slika(returnBitmap);
        }

        public static Bitmap Slika2Bitmap(Slika original)
        {
            return new Bitmap(original.bmp);
        }
    }
}
