using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using SlikaLib;

namespace Zlatko
{
    public class element{
        public int x,y;
        public element(int x, int y)
        {
            this.x = x;
            this.y = y;
        }
    }

    public class stukturniElement
    {
        element [] elementi = null;
        int brojElemenata = 0;
        int current = 0;
        public stukturniElement(int brojElemenata)
        {
            this.brojElemenata = brojElemenata;
            elementi = new element[brojElemenata];
        }

        public void beginUpdate(){
            current = 0;
        }

        public bool updateDone(){
            return current == brojElemenata;
        }

        public void updateElement(element e){
            elementi[current++] = e;
        }

        public void setElementAt(int index, element e)
        {
            try{
                elementi[index] = e;
            }catch(Exception)
            {
                MessageBox.Show("Pogrean indeks!", "Greka");
            }
        }
        public element getElementAt(int index)
        {
            return elementi[index];
        }

        public element getNext(){
            try{
                return elementi[current++];
            }catch(Exception)
            {
                MessageBox.Show("Pogrean indeks!", "Greka");
                return null;
            }
        }

        public bool hasElement()
        {
            return brojElemenata > 0;
        }

        public bool hasNext(){
            return current < brojElemenata;
        }

        public element getFirst(){
            current=0;
            if(brojElemenata > 0)
                return elementi[current];
            else
                MessageBox.Show("Strukturni element je prazan skup!", "Greka");
            return null;
        }
    }

    public class Morfologija
    {
        public static stukturniElement strElement = null;
        public static Slika dilatacija(Slika slika)
        {
            if ((strElement != null) && (strElement.hasElement()))
            {
                Slika copy = slika.getImgCopy();
                Slika s = new Slika(copy.Width, copy.Height, imgType.binary);
                for (int i = 0; i < s.Width; i++)
                    for (int j = 0; j < s.Height; j++)
                        s.setPixelAt(i, j, 1);
                for (int i = 0; i < copy.Width; i++)
                    for (int j = 0; j < copy.Height; j++)
                        if (copy.getPixelAt(i, j) == 0)
                        {
                            element e = strElement.getFirst();
                            if (!(((e.x + i) < 0) || ((e.x + i) >= copy.Width)
                                || ((e.y + j) < 0) || ((e.y + j) >= copy.Height)))
                                s.setPixelAt((e.x + i), (e.y + j), 0);
                            while (strElement.hasNext())
                            {
                                e = strElement.getNext();
                                if (!(((e.x + i) < 0) || ((e.x + i) >= copy.Width)
                                || ((e.y + j) < 0) || ((e.y + j) >= copy.Height)))
                                    s.setPixelAt((e.x + i), (e.y + j), 0);
                            }
                        }
                slika = s;
            }
            else
            {
                MessageBox.Show("Strukturni element je prazan skup! Postavite strukturni element.", "Greka");
            }
            return slika;
        }

        public static Slika erozija(Slika slika)
        {
            if ((strElement != null) && (strElement.hasElement()))
            {
                Slika copy = slika.getImgCopy();
                Slika s = new Slika(copy.Width, copy.Height, imgType.binary);
                for (int i = 0; i < s.Width; i++)
                    for (int j = 0; j < s.Height; j++)
                        s.setPixelAt(i, j, 1);
                for (int i = 0; i < copy.Width; i++)
                    for (int j = 0; j < copy.Height; j++)
                        if (copy.getPixelAt(i, j) == 0)
                        {
                            bool flag = true;
                            element e = strElement.getFirst();
                            if (!(((e.x + i) < 0) || ((e.x + i) >= copy.Width)
                                || ((e.y + j) < 0) || ((e.y + j) >= copy.Height)))
                                if (copy.getPixelAt((e.x + i), (e.y + j)) == 1)
                                    flag = false;

                            while (strElement.hasNext())
                            {
                                e = strElement.getNext();
                                if (!(((e.x + i) < 0) || ((e.x + i) >= copy.Width)
                                || ((e.y + j) < 0) || ((e.y + j) >= copy.Height)))
                                    if (copy.getPixelAt((e.x + i), (e.y + j)) == 1)
                                    {
                                        flag = false;
                                        break;
                                    }                                    
                            }
                            if(flag) s.setPixelAt(i, j, 0);
                        }
                slika = s;
            }
            else
            {
                MessageBox.Show("Strukturni element je prazan skup! Postavite strukturni element.", "Greka");
            }
            return slika;
        }

        public static Slika otvaranje(Slika s)
        {
            return dilatacija(erozija(s));
        }
        public static Slika zatvaranje(Slika s)
        {
            return erozija(dilatacija(s));
        }
    }
}
