% Segmentacija slike koriscenjem ivicnih piksela (laplasijana)
clear, close, clc
a=imread('tekst1.jpg');
h=fspecial('laplacian',0);
lap=imfilter(a, h, 'replicate');
hist = imhist(lap); 
hist = hist/sum(hist); 
c = cumsum(hist); 
ind = find(c <= 0.85); 
pct85 = max(ind);
maska=lap > pct85;
slika = a.* uint8(maska);

subplot(221), imshow(a), title('Orginalna slika');
subplot(222), imshow(lap), title('Laplasijan slike');
subplot(223), imshow(maska), title('maska');
subplot(224), imshow(slika), title('(Orginalna slika)*maska');

figure, subplot(121), imhist(a), title('histogram orginalne slike');
subplot(122), imhist(slika), title('histogram od (orginal)*maska');
binarna = im2bw(a, 124/256); 
figure, imshow(binarna), title('Segmentirana slika');