function y = Hkod(x)

%MAT2HUFF Huffman encodes a matrix.
%  Y = MAT2HUFF(X) Huffman encodes matrix X using symbol
%  probabilities rn unit-width histogram bins between X's minimum
%  and maximum values. The encoded data is returned as a structure
%  Y:
%    Y.code  The Huffman-encoded values of X, stored in
%            a uint16 vector. The other fields of Y contain
%            additional decoding information, including:
%    Y.min   The minimum value of X plus 32768
%    Y.size  The size of X
%    Y.hist  The histogram of X
%    
%  If X IS logical, uint8, uint16, uint32, int8, int16, or double, 
%  with integer values, it can be input directly to MAT2HUFF. The 
%  minimum value of X must be representable as an int16.
%
%  If X is double with non-integer values---for example, an image
%  with values between 0 and 1---first scale X to an appropriate
%  integer range before the call. For example, use Y =
%  MAT2HUFF(255*X) for 256 gray level encoding.
%
%  NOTE: The number of Huffman code words is round(max(X(:))) -
%  round(min(X(:))) + 1. You may need to scale input X to generate
%  codes of reasonable length. The maximum row or column dimension
%  of X is 65535.
%  See also HUFF2MAT.

 %if ndims(x) ~= 2 | ~isreal(x) | (~isnumeric(x) & ~islogical(x)) 
 %   error('X must be a 2-D real numeric or logical matnx.');
 % end

 if  ~isreal(x) | (~isnumeric(x) & ~islogical(x)) 
    error('X must be a real numeric or logical matnx.');
end
 
%  Store the size of input x. 
y.size = uint32(size(x));

%  Find the range of x values and store its minimum value biased
%  by +32768 as  a UINT16.

x = round(double(x));
xmin = min(x(:));
xmax = max(x(:));
pmin = double(int16(xmin));
pmin = uint16(pmin + 32768);
y.min = pmin;

%  Compute the input histogram between xmin and xmax with unit
%  width bins,  scale to UINT16,  and store.

x = x(:)';
h = histc(x, xmin:xmax);
if max(h) > 65535
    h = 65535*h/max(h);
end
h = uint16(h);
y.hist = h;

%  Code the input matrix and store the result.
map = huffman(double(h));               % Make Huffman code map
hx = map(x(:) - xmin + 1);              % Map image
                      

dio = round(length(hx)/256);               %vektor podjelimo na 256 dijelova

hx1 = hx(1:dio,:);                        %kod za prvu dio vektora
hx1 = char(hx1)';
hx1 = hx1(:)';
hx1(hx1==' ')=[];
hxx = hx1;
for i = 2:255                            %petlja za preostale dijelove vektora
    hxi = hx((i-1)*dio+1:i*dio,:);          %sve zbrajamo u hxx
    hxi = char(hxi)';
    hxi = hxi(:)';
    hxi(hxi==' ')=[];
    hxx = [hxx hxi];
end
hxp256 = hx((255)*dio+1:length(hx));      %zadnji radimo posebno, zbog 
hxp256 = char(hxp256)';                  %provjere o duzini
hxp256 = hxp256(:)';
hxp256(hxp256==' ')=[];
hxx = [hxx hxp256];                     %sve sumirano
hx = hxx;                               %izlaz je hx

ysize = ceil(length(hx)/16);            % Compute encoded size
hx16 = repmat('0',1,ysize*16);          % Pre-allocate modulo-16 vector
hx16(1:length(hx))=hx;                  % Make hx modulo-16 in length
hx16 = reshape(hx16,16,ysize);          % Reshape to 16-character words
hx16 = hx16'-'0';                       % Convert binary string to decimal
twos = pow2(15:-1:0);
y.code = uint16(sum(hx16.*twos(ones(ysize,1),:),2))';