%Funkcija koja trazi centralne koordinate zjenice i sarenice kao i njihove radijuse.
%Koristi 'Camus&Wildes' metodu da selektuje moguce koordinate centra.
%Ova metoda se sastoji od odredjivanja praga iza cega slijedi provjera da
%li je selektovana tacka lokalni minimum u prozoru od 3x3 piksela.
%Ove tacke su moguce koordinate centra sarenice.
%Jednom kada je sarenica detektovana (koristenjem Dougmanovog metoda)
%prelazimo na detekciju centra zjenice, tako sto pretrazujemo prozor od
%10x10 piksela u okolini centra zjenice i varirajuci radijus dok se ne
%nadje maksimum (koristeci Daugmanov integrodiferencijalni operator)

%ULAZI:
%I:slika za segmentaciju
%rmin ,rmax: minimalna i maksimalna vrijednost poluprecnika sarenice
%IZLAZI:
%cp: parametri[xc,tc,r] granica zjenice
%ci: parametri[xc,yc,r] granica sarenice
%out: segmentirana slika

function [ci,cp,out]=thresh(I,rmin,rmax);
I = rgb2gray(I);
scale=1;
%skaliranje slike da bi se ubrzao cijeli proces
rmin=rmin*scale;
rmax=rmax*scale;
%svi parametri se skaliraju zadatom skalom
I=im2double(I);
%aritmeticke operacije nisu definisane u uint8
%jer se slika konvertuje u double
pimage=I;
%cuva se originalna slika koja ce poslije posluziti za prikaz segmentirane
%slike
I=imresize(I,scale);
I=imcomplement(imfill(imcomplement(I),'holes'));
%odstranjivanje odsjaja koji se moze javiti u zjenici
rows=size(I,1);
cols=size(I,2);
[X,Y]=find(I<0.5);
%kreira vektor kolonu elemenata slike
%koji su bili izabrani pragom;za x i y koordinatu
s=size(X,1);
for k=1:s 
    if (X(k)>rmin)&(Y(k)>rmin)&(X(k)<=(rows-rmin))&(Y(k)<(cols-rmin))
            A=I((X(k)-1):(X(k)+1),(Y(k)-1):(Y(k)+1));
            M=min(min(A));
            %ovaj proces skenira susjedstvo selektovanog piksela
            %da bi provjerio da li je on lokalni minimum
           if I(X(k),Y(k))~=M
              X(k)=NaN;
              Y(k)=NaN;
           end
    end
end
v=find(isnan(X));
X(v)=[];
Y(v)=[];
%brise sve piksele koji nisu lokalni minimum (koji su postavljeni na NaN)
index=find((X<=rmin)|(Y<=rmin)|(X>(rows-rmin))|(Y>(cols-rmin)));
X(index)=[];
Y(index)=[];  
%Ovaj proces brise sve piksele koji su tako blizu granice da nije moguce da
%budu koordinate centra
N=size(X,1);
%ponovo racunanje dimenzija nakon brisanja nepotrebnih elemenata
maxb=zeros(rows,cols);
maxrad=zeros(rows,cols);
%definisanje dva niza maxb i maxrad u koje ce se smjestiti maksimalna
%vrijednost zamucenja za svaku selektovanu centralnu tacku i odgovarajuci
%poluprecnik
for j=1:N
    [b,r,blur]=partiald(I,[X(j),Y(j)],rmin,rmax,'inf',600,'iris');%coarse search
    maxb(X(j),Y(j))=b;
    maxrad(X(j),Y(j))=r;
end
[x,y]=find(maxb==max(max(maxb)));
ci=search(I,rmin,rmax,x,y,'iris');
%nalazenje maksimalne vrijednosti zamucenja skeniranjem svih koordinata
%centra
ci=ci/scale;
%funkcija koja trazi koordinate centra zjenice i njen poluprecnik tako sto
%skenira prozor dimenzija 10*10 oko centra sarenice
cp=search(I,round(0.1*r),round(0.8*r),ci(1)*scale,ci(2)*scale,'pupil');
cp=cp/scale;
%prikaz segmentirane slike
slika = zeros(150, 200);
out1=drawcircle(slika,[ci(1),ci(2)],ci(3),600);
out2=drawcircle(slika,[cp(1),cp(2)],cp(3),600);
out1=1-imfill(out1,'holes');
out2=imfill(out2,'holes');
out = 1-xor(out1,out2);
out = out.*pimage;
