%Funkcija koja vrsi detekciju same granice donjeg kapka. Ideja je bazirana
%na racunanju izvoda na odgovarajucem prozoru koji se konstantno kalibrira
%i prevlaci pro granici kapka i sarenice. Na taj nacin se detektuje najveca
%promjena koja se potvrdjeno podudara sa granicom kapka
%ULAZI:
%1.I:Slika za procesiranje
%2.C(x,y):Centar zjenice, od kojeg se po x osi vertikalno, zbog izbora
%koordinatnog sistema, uzima niz piksela nad kojima se trazi prva granica
%izmedju kapka i sarenice
%3.rPupil:radijus zjenice
%4.rIris:radijus sarenice


function O=eyelid(I,C,rPupil,rIris)
O=I;
I=imcomplement(imfill(imcomplement(I),'holes'));%ocisti sliku od refleksije prije obrade jer ovdje proslijedjuje se orginalna slika
vektor=I(C(1)+rPupil+4:C(1)+ rIris-1,C(2));%generisanje prvog vektora koji se koristi za detekciju prelaza kapka i sarenice
D=diff(vektor);
D=D';
D=[0 D];
D=D';
f=fspecial('gaussian',[1 5]);
blur=convn(D,f,'same');
blur=abs(blur);
[b,i]=max(blur);
ref=C(1)+i+rPupil+4;%postavljanje referentne tacke koja se koristi za kalibraciju prozora u daljim pomjeranjima
refPocetno = ref;
O(ref,C(2))=0;%postavljanje prve tacke na crnu

for k=ref:150
        O(k,C(2))=0;%postavljanje svih tacaka ispod referentne na nulti nivo svjetline
end
    
j=2; 
flag=0;
for n=(C(2)-1):-1:C(2)-rIris% petlja za pomjernja u lijevo
    korak = 3;
    vektor=I(ref-korak:ref+korak,n);%generisanje prozora    
    D=diff(vektor);
    D=D';
    D=[0 D];
    D=D';
    
    f=fspecial('gaussian',[1 5]);
    blur=convn(D,f,'same');
    blur=abs(blur);
    [b,i]=max(blur);  
    if(flag==1)
    i=traceLine(I,n,ref);%provjera korektnosti odabrane tacke, kako u narendim koracima nebi doslo do propadanja piksela
    end
    %naredne linije vrse rekalibraciju pozicije prozora pri pomjeranju
    if(i<korak)
        ref=ref-(korak-i);
    end
    if(i>=korak)
        ref=ref+(i-korak);
    end
    
    O(ref,n)=0;
    %postavljanje tacaka na nulti nivo svjetline, cime se masika donji
    %kapak
    for k=ref:150
        O(k,n)=0;
    end
    j=j+1;
    flag=1;% postavljanje flag-a jer se pri prvom prelazu funkcija traceLine ne smije pokrenuti, zbog pojave spica u maski
end

ref = refPocetno;
flag=0;
for n=(C(2)+1):C(2)+ rIris
    korak2 = 3;
    vektor=I(ref-korak2:ref+korak2,n);
    
    D=diff(vektor);
    D=D';
    D=[0 D];
    D=D';
    
    f=fspecial('gaussian',[1 5]);
    blur=convn(D,f,'same');
    blur=abs(blur);
    [b,i]=max(blur);
    if(flag==1)
    i=traceLine(I,n,ref);
    end
      
    if(i<korak2)
        ref=ref-(korak2-i);
    end
    if(i>=korak2)
        ref=ref+(i-korak2);
    end
   
    O(ref,n)=0;
    
    for k=ref:150
        O(k,n)=0;
    end
    
    j=j+1;
    flag=1;
end
    
    


