%funkcija za izracunavanje normalizovanog integrala po kruznoj putanji
%Putanja je aproksimirana n-ugaonikom i integral se priiblizno izracunava
%odgovarajucom sumom
%ULAZI
%1.I:Slika za procesiranje
%2.C(x,y):centralen koordinate pomenutog kruga po kojem se integral racuna
%3.n:broj strana aproksimirane kruzne putanje
%4.r:radius aproksimacije putanje
%5.part:da li se trazi sarenica ili zjenica
%ako se trazi zjenica, sumiranje s evrsi po cijeloj putanji, a kod
%sarenice, zbog mogucnosti interferencije sa kapkom racuna se samo dio
%putanje
%IZLAZ
%L:linijski integral podjeljen brojem n
function [L]=lineint(I,C,r,n,part)
theta=(2*pi)/n;% korak integraljenja tj. sumiranja
rows=size(I,1);
cols=size(I,2);
angle=theta:theta:2*pi;
x=C(1)-r*sin(angle);
y=C(2)+r*cos(angle);
if (any(x>=rows)|any(y>=cols)|any(x<=1)|any(y<=1))
    L=0;
    return
    %Vraca L=0 kada putanja izlazi iz okvira slike
end
%proracun kompletnog integrala za zjenicu
if (strcmp(part,'pupil')==1)
          s=0;
          for i=1:n
          val=I(round(x(i)),round(y(i)));
          s=s+val;
          end
          
          L=s/n;
      end
%racunanje djelomicnog integrala za sarenicu
if(strcmp(part,'iris')==1)
          s=0;
          for i=1:round((n/8))
          val=I(round(x(i)),round(y(i)));
          s=s+val;
          end
          
          for i=(round(3*n/8))+1:round((5*n/8))
          val=I(round(x(i)),round(y(i)));
          s=s+val;
          end
          
          for i=round((7*n/8))+1:(n)
          val=I(round(x(i)),round(y(i)));
          s=s+val;
          end
          
          L=(2*s)/n;
end