%funkcija za pronalazenje parcijalnog izvida
%izracunava parcijalni izvod normalizovanog linijskog integrala
%drzeci centralene koordinate konstantnim
%a potom ih izglaca koristenjem odgovarajuce sigme sa Gausa
%%rmin and rmax are the minimum and maximum values of radii expected
%ULAZI:
%I;ulazna slika
%C:centralene koordinate
%rmin,rmax:minimalni i maksimalni radijusi
%n:broj stranica aproksimiranog kruga(za lineint)
%part:da li se trazi sarenica izli zjenica
%sigma:standardna Gausova devijacija
%IZLAZI:
%blur:vektor izvoda
%r:radijus na mjestu maksimalne vrijednosti vektora blur
%b:maksimalna vrijednost blura
function [b,r,blur]=partiald(I,C,rmin,rmax,sigma,n,part);
R=rmin:rmax;
count=size(R,2);
for k=1:count
[L(k)]=lineint(I,C,R(k),n,part);%preracunava normalizovan integral za svaki radijus
if L(k)==0%u slucaju da radijus iskace iz dimenzija slike, pri tome se for petlja prekida
     L(k)=[];
    break;
end
end
D=diff(L);
D=[0 D];
if strcmp(sigma,'inf')==1
f=ones(1,7)/7;
else
f=fspecial('gaussian',[1,5],sigma);%generisanje gausiana
end
blur=convn(D,f,'same');%uglacavanje vektora D konvolucijom 
%'same' ukazuje da je size(blur) jednak size(D)
blur=abs(blur);
[b,i]=max(blur);
r=R(i);
b=blur(i);
