%Funkcija s akojom se osiguravamo od propadanja piksela. Sadrzi dva korak,
%koja se uslovno ukljucuju u zavisnosti od toga da li je u svakom od njih
%doslo do propadanja ili ne. U slucaju da je do propadanja doslo, za
%referentnu tacku se uzima slijedeca manja promijena.
%ULAZI:
%1.I:Ulazna slika
%2.n:trenutni pomjeraj lijevo ili desno
%3.ref:trenutna referentna tacka
%IZLAZI:
%1.i korigovani faktor kalibracije referentne tacke
function i=traceLine(I,n,ref)
n=n-1;%uzima se naredni korak, znak - je posljedica koordinatnog sistema
korak = 3;
vektor=I(ref-korak:ref+korak,n);    
D=diff(vektor);
D=D';
D=[0 D];
D=D';
    
f=fspecial('gaussian',[1 5]);
blur=convn(D,f,'same');
blur=abs(blur);
[b,i]=max(blur); 
 if(i<korak)
        refNovo=ref-(korak-i);
    end
    if(i>=korak)
        refNovo=ref+(i-korak);
    end
    %proracun da li je nova refentna tacka ispod prethodne
if(refNovo>ref)
    n=n-1;
    korak = 3;
    vektor=I(ref-korak:ref+korak,n);    
    D=diff(vektor);
    D=D';
    D=[0 D];
    D=D';
    
    f=fspecial('gaussian',[1 5]);
    blur=convn(D,f,'same');
    blur=abs(blur);
    [b,i]=max(blur);
    if(i<korak)
        refNovo1=ref-(korak-i);
    end
    if(i>=korak)
        refNovo1=ref+(i-korak);
    end
    %proracun da li je druga po redu referentna tacka niza od prethodne,
    %ako jeste prelazi se na korekciju faktora kalibracije
    if(refNovo1>refNovo)
        n=n+2;
        korak = 3;
        vektor=I(ref-korak:ref+korak,n);    
        D=diff(vektor);
        D=D';
        D=[0 D];
        D=D';
    
        f=fspecial('gaussian',[1 5]);
        blur=convn(D,f,'same');
        blur=abs(blur);
        [b,i]=max(blur);
        %korekcija faktora kalibracije, prve tacke u nizu proba, s tim da
        %se data maksimalna promjena u izvodu izjednaci sa 0 i trazi se
        %naredna manja koja odgovara korektnoj referentnoj tacki, tj njenom
        %faktoru kalibracije i
        blur(i)=0;
        [b,i]=max(blur);
    end
end       
        
    