function n = besselord(w1,dt,w2,Ap)
% BESSELORD Odredjivanje reda Besselovog filtra
%    N = BESSELORD(w1, dt, w2, Ap) vraca red Besselovog filtra
%    sa kasnjenjem manjim od dt procenata do ucestanosti w1 i
%    slabljenjem manjim od Ap dB do ucestanosti w2
for k = 1:25
    b0 = factorial(2*k)/factorial(k)/(2^k);
    wn = b0^(1/k);
    [b,a] = besself(k,wn);
    if dt >= 100*(1-groupdelay(b,a,w1))
        h = -20*log10(abs(freqs(b,a,[0 w2])));
        if Ap >= h(2)
            n = k;
            return;
        end
    end
end

function tau = groupdelay(b, a, w)

s = j*w;
ad = polyder(a);
tau = 0.5*(polyval(ad, s)./polyval(a, s) + polyval(ad, -s)./polyval(a, -s));
tau = real(tau);

function k = factorial(n)

k = 1;
for i=2:n
   k = k*i;
end
