function freqplot(xa, dt)

Fs = 1/dt;
xa = xa(:);
L = length(xa);
Nfft = round(2.^round(log2(5*L)));
Xa = fft(xa, Nfft)/(L/2);
range = 0:(Nfft/2);
ff = range/Nfft*Fs;
plot(ff/1000, abs(Xa(range+1)));
title('Cont-time Fourier transform (mag)');
xlabel('Frequency (kHz)'), grid
