% Izdvajanje deskriptora iz baze slika.
% Elektrotehnicki fakultet, Univerzitet u Banjoj Luci, 2014.

clear

% definisi parametre 
conf = get_conf();

tic

% Ucitava se svaka slika iz zadatog direktorijuma i za nju se izracunava
% prostorna raspodjela boja. Deskriptori se formiraju preuredjivanjem
% matrice raspodjele boja u vektor.
dir_list = dir([conf.images_filepath filesep '*' conf.ext]);
for i = 1:length(dir_list)
    filename = char(dir_list(i).name)
    a = imread([conf.images_filepath filesep filename]);
    a = im2double(a);
    features{i}.filename = filename;
    features{i}.desc = compute_color_histogram(a, conf);
end

save(conf.desc_filename, 'features')

toc
